/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.lighthouse;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeviceFlag {
    RUNNING("running!", 1),
    SAMPLING("sampling!", 2),
    NEW_DATA("data!", 4),
    ERROR("error!", 8);

    private final String text;
    private final int mask;

    private DeviceFlag(String text, int mask) {
        this.text = text;
        this.mask = mask;
    }

    public String toString() {
        return this.text;
    }

    public int getMask() {
        return this.mask;
    }

    public static Set<DeviceFlag> flagsFromMask(int mask) {
        EnumSet flags = Stream.of(DeviceFlag.values()).filter(flag -> (flag.getMask() & mask) != 0).collect(Collectors.toCollection(() -> EnumSet.noneOf(DeviceFlag.class)));
        return Collections.unmodifiableSet(flags);
    }
}

