package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.Map;

/**
 * Defines the interface to trendable data from an instrument.
 * @author tether
 */
public interface TrendableRecord {

    /** Gets the master key for the record.
     * @return The key.
     */
    String getMasterKey();

    /** Gets the master timestamp for the record.
     * @return The timestamp.
     */
    Instant getMasterTimestamp();

    /**
     * Gets the value of the limit violation flag for this record.
     * @return The flag, or false if the flag isn't present.
     * @throws Error if the flag has an invalid type or value..
     */
    boolean hasLimitViolation();

    /**
     * Gets the value of the instrument malfunction flag for this record.
     * @return The flag, or false if the flag isn't present.
     * @throws Error if the flag has an invalid.
     */
    boolean hasMalfunction();

    /**
     * Gets the map of trending keys to serializable values.
     * @return The map (unmodifiable).
     */
    Map<String, Serializable> getItems();

    /**
     * Post this data to the local CCS trending database. The master key and timestamp
     * become the key and timestamp of a {@code KeyValueDataList} to which is added
     * one {@KeyValueData} item for each data channel.
     * @param subsys A reference to the CCS subsystem object.
     */
    void post(org.lsst.ccs.Subsystem subsys);

}
