/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;

public final class TrendableRecord {
    public static String LIMIT_VIOLATION_KEY = "limitViolation";
    public static String MALFUNCTION_KEY = "malfunction";
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Serializable> items;

    public TrendableRecord(String masterKey, Instant masterTimestamp, Map<String, Serializable> items) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.items = Collections.unmodifiableMap(items);
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    public boolean hasLimitViolation() {
        Serializable flag = this.items.get(LIMIT_VIOLATION_KEY);
        if (flag instanceof Double) {
            return (Double)flag >= 0.5;
        }
        throw new Error("Limit violation flag isn't present or isn't Double: " + flag);
    }

    public boolean hasMalfunction() {
        Serializable flag = this.items.get(MALFUNCTION_KEY);
        if (flag instanceof Double) {
            return (Double)flag >= 0.5;
        }
        throw new Error("Malfunction flag isn't present or isn't Double: " + flag);
    }

    public Map<String, Serializable> getItems() {
        return this.items;
    }

    public void post(Subsystem subsys) {
        KeyValueDataList kvdl = new KeyValueDataList(this.masterKey, this.masterTimestamp.toEpochMilli());
        this.items.forEach((key, value) -> kvdl.addData(key, value));
        subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.items.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

