package org.lsst.ccs.subsystem.airwatch.main;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;


/**
 * Holds configuration information about a location.
 * @author tether
 */
public final class LocationConfig {
    
    /** The name of the location. */
    public final String name;
    
    /** The zero-based position of the name in the list of legal location names. */
    public final int index;
    
    /** The thresholds to apply to each instrument particle channel. May be empty.*/
    public final Map<InstrumentChannel, Long> thresholds;
    
    /**
     * Constructs an instance.
     * @param name See {@link #name}.
     * @param index See {@link #index}.
     * @param thresholds See {@link #thresholds}.
     */
    public LocationConfig(String name, int index, Map<InstrumentChannel, Long> thresholds) {
        this.name = name;
        this.index = index;
        this.thresholds =
            Collections.unmodifiableMap(new EnumMap<>(thresholds));
    }
    
}
