package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Instant;

import java.util.List;

/**
 * The configuration information maintained for each instrument. The {@code type} field is interpreted by
 * {@link AirwatchMain}. The other fields are used by an implementation of {@link Instrument}.
 */
public final class InstrumentConfig {

    /**
     * The position of the configuration in the list, counting from zero.
     */
    public final int index;

    /**
     * The make and/or model of the instrument.
     */
    public final InstrumentType type;

    /**
     * The information needed to open a connection to an instrument.
     */
    public final String conn;

    /**
     * The current location being monitored by the instrument.
     */
    public final String loc;

    /**
     * The next readout of the instrument will fetch only data newer than this time.
     */
    public final Instant lastDataTime;

    public InstrumentConfig(
        int index,
        InstrumentType type,
        String conn,
        String loc,
        Instant lastDataTime)
    {
        this.index = index;
        this.type = type;
        this.conn = conn;
        this.loc = loc;
        this.lastDataTime = lastDataTime;
    }
}
