/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;

public class TrendableRecord {
    private final String masterKey;
    private final Instant masterTimestamp;
    private final Map<String, Double> channels;

    public TrendableRecord(String masterKey, Instant masterTimestamp, Map<String, Double> channels) {
        this.masterKey = masterKey;
        this.masterTimestamp = masterTimestamp;
        this.channels = Collections.unmodifiableMap(channels);
    }

    public String getMasterKey() {
        return this.masterKey;
    }

    public Instant getMasterTimestamp() {
        return this.masterTimestamp;
    }

    public void post(Subsystem subsys) {
        KeyValueDataList kvdl = new KeyValueDataList(this.masterKey, this.masterTimestamp.toEpochMilli());
        this.channels.forEach((key, value) -> kvdl.addData(key, (Serializable)value));
        subsys.publishSubsystemDataOnStatusBus((KeyValueData)kvdl);
    }

    public String toString() {
        StringBuilder repr = new StringBuilder();
        repr.append(String.format("Master key: %s%n", this.masterKey));
        repr.append(String.format("Master time: %s%n", this.masterTimestamp.toString()));
        this.channels.forEach((key, value) -> repr.append(String.format("    %s: %s%n", key, value.toString())));
        return repr.toString();
    }
}

