package org.lsst.ccs.subsystem.airwatch.main;

import java.util.Optional;

import java.util.stream.Stream;

/**
 * The quantities monitored by each instrument.
 * @author tether
 */
public enum InstrumentChannel {

    /** The count of all particles of size 0.3 microns or larger. */
    COUNTER_0_3("0.3", true),

    /** The count of all particles of size 0.5 microns or larger. */
    COUNTER_0_5("0.5", true),

    /** The count of all particles of size 1.0 microns or larger. */
    COUNTER_1_0("1.0", true),

    /** The count of all particles of size 2.5 microns or larger. */
    COUNTER_2_5("2.5", true),

    /** The count of all particles of size 5.0 microns or larger. */
    COUNTER_5_0("5.0", true),

    /** The count of all particles of size 10.0 microns or larger. */
    COUNTER_10_0("10.0", true),

    /** The temperature in degrees Fahrenheit. */
    TEMPERATURE("temp", false),

    /** The relative humidity expressed as a percentage. */
    HUMIDITY("humid", false);

    private final String key;

    private final boolean particle;

    InstrumentChannel(String key, boolean particle) {
        this.key = key;
        this.particle = particle;
    }

    /**
     * Gets the trending key used to identify the channel.
     * @return The key.
     */
    public String getKey() {return key;}

    /**
     * Determines whether a channel is a particle count.
     * @return The boolean flag.
     */
    public boolean isParticleChannel() {return particle;}

    /**
     * Converts a trending key string into the corresponding channel.
     * @param key The trending key.
     * @return An empty Optional if the key is invalid, otherwise an Optional holding
     * the enum value.
     */
    public static Optional<InstrumentChannel> parse(String key) {
        return Stream.of(InstrumentChannel.values())
            .filter(chan -> key.equalsIgnoreCase(chan.getKey()))
            .findAny();
    }
}
