/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.lighthouse.DataRecord;
import org.lsst.ccs.drivers.lighthouse.LighthouseClient;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.LocationConfig;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;

public class LighthouseInstrument
implements Instrument {
    private static final Duration DEVICE_TIMEOUT = Duration.ofSeconds(10L);
    private static final boolean DEVICE_DEBUG = false;
    private final int index;
    private final boolean enabled;
    private final String location;
    private final Instant lastDataTime;
    private final Callable<LighthouseClient> connector;
    private final Optional<HardwareException> lastException;
    private final List<TrendableRecord> trendables;

    public LighthouseInstrument(InstrumentConfig config) {
        this.index = config.index;
        this.enabled = false;
        this.location = config.loc;
        this.lastDataTime = config.lastDataTime;
        this.connector = LighthouseInstrument.parseConnectionInfo(config.conn);
        this.lastException = Optional.empty();
        this.trendables = Collections.EMPTY_LIST;
    }

    private LighthouseInstrument(int index, boolean enabled, String location, Instant lastDataTime, Callable<LighthouseClient> connector, Optional<HardwareException> lastException, List<TrendableRecord> trendables) {
        this.index = index;
        this.enabled = enabled;
        this.location = location;
        this.lastDataTime = lastDataTime;
        this.connector = connector;
        this.lastException = lastException;
        this.trendables = trendables;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastException;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, this.location, this.lastDataTime);
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.trendables.stream();
    }

    @Override
    public Instrument disable() {
        return new LighthouseInstrument(this.index, false, this.location, this.lastDataTime, this.connector, this.lastException, this.trendables);
    }

    @Override
    public Instrument enable(LocationConfig loc) {
        return new LighthouseInstrument(this.index, false, this.location, this.lastDataTime, this.connector, Optional.empty(), Collections.EMPTY_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Instrument read() {
        LighthouseInstrument ins;
        Instant newLast;
        List<TrendableRecord> newData;
        Stream records;
        HardwareException hwexc;
        block14: {
            LighthouseClient client = null;
            hwexc = null;
            records = Stream.empty();
            newData = Collections.EMPTY_LIST;
            newLast = this.lastDataTime;
            ins = null;
            try {
                client = this.connector.call();
                records = client.getRecentRecords(this.lastDataTime);
            }
            catch (Exception exc) {
                if (exc instanceof DriverException) {
                    hwexc = new HardwareException(true, (Throwable)exc);
                    records = Stream.empty();
                    break block14;
                }
                throw new Error(exc);
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (DriverException driverException) {}
                }
            }
        }
        newData = LighthouseInstrument.extractTrendables(records);
        if (newData.size() > 0) {
            newLast = newData.get(0).getMasterTimestamp();
        }
        ins = new LighthouseInstrument(this.index, this.enabled, this.location, newLast, this.connector, Optional.ofNullable(hwexc), Collections.unmodifiableList(newData));
        return ins;
    }

    private static Callable<LighthouseClient> parseConnectionInfo(String info) {
        String[] words = info.trim().split("\\w");
        String method = words[0].toLowerCase();
        String parameters = words[1];
        Callable<LighthouseClient> connector = null;
        if (method.equals("serial")) {
            connector = () -> LighthouseClient.serialOpen((String)parameters, (Duration)DEVICE_TIMEOUT, (boolean)false);
        } else if (method.equals("ftdi")) {
            connector = () -> LighthouseClient.ftdiOpen((String)parameters, (Duration)DEVICE_TIMEOUT, (boolean)false);
        } else if (method.equals("net")) {
            words = parameters.split(":");
            String host = words[0];
            int portNo = Integer.parseUnsignedInt(words[1]);
            connector = () -> LighthouseClient.netOpen((String)host, (int)portNo, (Duration)DEVICE_TIMEOUT, (boolean)false);
        } else {
            throw new IllegalArgumentException("Illegal Lighthouse connection type: " + method);
        }
        return connector;
    }

    private static List<TrendableRecord> extractTrendables(Stream<DataRecord> records) {
        return records.map(rec -> {
            String key = rec.getLocation();
            Instant stamp = rec.getStartTime();
            Map<String, Double> channels = rec.getChannels().collect(Collectors.toMap(datum -> datum.getChannel().getName(), datum -> datum.getValue()));
            return new TrendableRecord(key, stamp, channels);
        }).collect(Collectors.toList());
    }
}

