/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.util.Optional;
import java.util.stream.Stream;

public enum InstrumentChannel {
    COUNTER_0_3("0.3", true),
    COUNTER_0_5("0.5", true),
    COUNTER_1_0("1.0", true),
    COUNTER_2_5("2.5", true),
    COUNTER_5_0("5.0", true),
    COUNTER_10_0("10.0", true),
    TEMPERATURE("temp", false),
    HUMIDITY("humid", false);

    private final String key;
    private final boolean particle;

    private InstrumentChannel(String key, boolean particle) {
        this.key = key;
        this.particle = particle;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isParticleChannel() {
        return this.particle;
    }

    public static Optional<InstrumentChannel> parse(String key) {
        return Stream.of(InstrumentChannel.values()).filter(chan -> key.equalsIgnoreCase(chan.getKey())).findAny();
    }
}

