/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.subsystem.airwatch.main.Instrument;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentChannel;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentConfig;
import org.lsst.ccs.subsystem.airwatch.main.InstrumentStatus;
import org.lsst.ccs.subsystem.airwatch.main.LocationConfig;
import org.lsst.ccs.subsystem.airwatch.main.TrendableRecord;

public class DummyInstrument
implements Instrument {
    private final int index;
    private final boolean enabled;
    private final String location;
    private final Instant lastDataTime;
    private final long nops;
    private final Optional<HardwareException> lastExc;
    private final Optional<TrendableRecord> lastData;

    public DummyInstrument(InstrumentConfig config) {
        this.index = config.index;
        this.enabled = false;
        this.location = config.loc;
        this.lastDataTime = config.lastDataTime;
        this.nops = 0L;
        this.lastExc = Optional.empty();
        this.lastData = Optional.empty();
    }

    private DummyInstrument(int index, boolean enabled, String location, Instant lastDataTime, long nops, Optional<HardwareException> exc, Optional<TrendableRecord> data) {
        this.index = index;
        this.enabled = enabled;
        this.location = location;
        this.lastDataTime = lastDataTime;
        this.nops = nops;
        this.lastExc = exc;
        this.lastData = data;
    }

    @Override
    public Optional<HardwareException> getLastException() {
        return this.lastExc;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public InstrumentStatus getStatus() {
        return new InstrumentStatus(this.index, this.enabled, this.location, this.lastDataTime);
    }

    @Override
    public Stream<TrendableRecord> getTrendables() {
        return this.lastData.map(Stream::of).orElseGet(Stream::empty);
    }

    @Override
    public Instrument disable() {
        long n = this.nops + 1L;
        Optional<HardwareException> exc = n % 5L == 0L ? Optional.of(new HardwareException("Simulated exception during disable.", null)) : Optional.empty();
        return new DummyInstrument(this.index, false, this.location, this.lastDataTime, n, exc, this.lastData);
    }

    @Override
    public Instrument enable(LocationConfig loc) {
        long n = this.nops + 1L;
        Optional<HardwareException> exc = n % 5L == 0L ? Optional.of(new HardwareException("Simulated exception during enable.", null)) : Optional.empty();
        return new DummyInstrument(this.index, true, loc.name, this.lastDataTime, n, exc, this.lastData);
    }

    @Override
    public Instrument read() {
        long n = this.nops + 1L;
        if (n % 5L == 0L) {
            return new DummyInstrument(this.index, this.enabled, this.location, this.lastDataTime, n, Optional.of(new HardwareException(false, "Simulated exception during read.")), Optional.empty());
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
            return new DummyInstrument(this.index, this.enabled, this.location, this.lastDataTime, n, Optional.empty(), Optional.empty());
        }
        Instant now = Instant.now();
        HashMap<String, Double> channels = new HashMap<String, Double>();
        channels.put(InstrumentChannel.COUNTER_1_0.getKey(), Math.cos(now.getEpochSecond()));
        TrendableRecord msg = new TrendableRecord(this.location, now, channels);
        return new DummyInstrument(this.index, this.enabled, this.location, now, n, Optional.empty(), Optional.of(msg));
    }
}

