package org.lsst.ccs.subsystem.airwatch.main;

import java.time.Duration;
import java.time.Instant;

import java.util.List;

/**
 * Represents a repository of configuration information. Note that updates act solely
 * on the external source of configuration data; the getters always return the values
 * extant at subsystem startup.
 * @author tether
 */
public interface ConfigurationService {

    /**
     * Gets an InstrumentConfig for each instrument described
     * by the configuration data.
     * @return The list of the configuration objects.
     */
    List<InstrumentConfig> getInstrumentConfigs();
    
    /**
     * Updates the information in the configuration database for a particular instrument.
     * @param stat The current status of the instrument.
     */
    void updateInstrument(InstrumentStatus stat);
    
    /**
     * Gets a LocationConfig for each location described by the configuration data.
     * @return The list of configuration objects.
     */
    List<LocationConfig> getLocationConfigs();
    
    /**
     * Gets the time between instrument readouts.
     * @return The time.
     */
    Duration getReadoutInterval();
}
