/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.ref.plotter.style.registry.IStyleStore;
import hep.aida.ref.plotter.style.registry.StyleStoreXMLWriter;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.freehep.application.RecentItemTextField;
import org.freehep.application.studio.Studio;
import org.jdom.JDOMException;

public class WriteStyleStorePanel
extends JPanel {
    private Component parent;
    private String title;
    private JPanel thisPanel;
    private RecentItemTextField outputFile = new RecentItemTextField("hep.aida.ref.plotter.style.registry.WriteStyleStorePanel.OutputFile", 15, false);
    private JFileChooser outputChooser = new JFileChooser();
    private JButton browse;
    private JCheckBox writeSetParameters = new JCheckBox("Write Only Set Parameters");

    public WriteStyleStorePanel() {
        this(null, "Write Style Store to XML File");
    }

    public WriteStyleStorePanel(Component parent) {
        this(parent, "Add Style Store Entry");
    }

    public WriteStyleStorePanel(String title) {
        this(null, title);
    }

    public WriteStyleStorePanel(Component parent, String title) {
        this.parent = parent;
        this.title = title;
        this.thisPanel = this;
        this.initComponents();
    }

    private void initComponents() {
        this.outputFile.setMinWidth(20);
        this.browse = new JButton("Browse...");
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String fileName = WriteStyleStorePanel.this.outputFile.getText();
                int returnVal = WriteStyleStorePanel.this.outputChooser.showOpenDialog(WriteStyleStorePanel.this.thisPanel);
                if (returnVal == 0) {
                    File file = WriteStyleStorePanel.this.outputChooser.getSelectedFile();
                    fileName = file.getAbsolutePath();
                    WriteStyleStorePanel.this.outputFile.setText(fileName);
                }
            }
        });
        this.writeSetParameters.setSelected(true);
        this.setBorder(new TitledBorder(new EtchedBorder(), this.title));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.add((Component)new JLabel(" Output File: "), gbc);
        gbc.gridx = 1;
        this.add((Component)this.outputFile, gbc);
        gbc.gridx = 2;
        this.add((Component)this.browse, gbc);
        gbc.gridy = 1;
        gbc.gridx = 1;
        this.add((Component)this.writeSetParameters, gbc);
    }

    public void writeStore(IStyleStore store) throws IOException, JDOMException {
        Component comp = this.parent;
        if (comp == null) {
            comp = SwingUtilities.getAncestorOfClass(Frame.class, this);
        }
        boolean wrongInput = true;
        while (wrongInput) {
            int reply = JOptionPane.showOptionDialog(comp, this, this.title, 0, -1, null, new String[]{"Ok", "Cancel"}, "Cancel");
            try {
                if (reply == 0) {
                    String fileName = this.outputFile.getText();
                    boolean writeAll = !this.writeSetParameters.isSelected();
                    StyleStoreXMLWriter.writeToFile(fileName, store, writeAll);
                    this.outputFile.saveState();
                }
                wrongInput = false;
            }
            catch (Exception e) {
                String message = "Error: " + e.getMessage();
                if (this.parent != null && this.parent instanceof Studio) {
                    Studio cfr_ignored_0 = (Studio)this.parent;
                    Studio.error((Component)this, (String)message, (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }
}

