/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.event.TreeModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTable;

public class TreeTable
extends MonitorTable
implements TreeTableModel {
    private final List<MonitorField> columns;
    private final DefaultTreeModel treeModel;
    private final Node root = new Node("");
    private boolean isInitialized = false;

    public TreeTable(Map<String, AbstractMonitorView.ChannelHandle> channels, List<MonitorField> fields) {
        Node node;
        this.columns = TreeTable.trimAbsentFields(fields, channels.values());
        for (Map.Entry<String, AbstractMonitorView.ChannelHandle> e : channels.entrySet()) {
            String[] path = e.getKey().split("/+");
            Node node2 = this.root;
            for (String nodeName : e.getKey().split("/+")) {
                node2 = this.addChild(node2, nodeName);
            }
            node2.setChannelHandle(e.getValue());
        }
        this.treeModel = new DefaultTreeModel(this.root);
        this.nRows = this.setRowNumbers(-1, this.root);
        this.nColumns = this.columns.size() + 1;
        this.cells = new ArrayList(this.nRows);
        for (int i = 0; i < this.nRows; ++i) {
            this.cells.add(new ArrayList(this.nColumns));
        }
        Enumeration<TreeNode> nodes = this.root.depthFirstEnumeration();
        while (nodes.hasMoreElements() && (node = (Node)nodes.nextElement()) != this.root) {
            List<AbstractMonitorView.ChannelHandle> handles;
            int row = node.getRow();
            if (node.isLeaf()) {
                handles = Collections.singletonList(node.getChannelHandle());
            } else {
                handles = new ArrayList<AbstractMonitorView.ChannelHandle>();
                Enumeration<TreeNode> nn = node.depthFirstEnumeration();
                while (nn.hasMoreElements()) {
                    Node n = (Node)nn.nextElement();
                    if (!n.isLeaf()) continue;
                    handles.add(n.getChannelHandle());
                }
                ((ArrayList)handles).trimToSize();
            }
            ((ArrayList)this.cells.get(row)).add(new MonitorTable.Cell(Collections.emptyList(), MonitorField.NULL, new MonitorTable.Data(node.toString(), MonitorTable.COLOR_FG, MonitorTable.COLOR_BG, 2)));
            for (MonitorField field : this.columns) {
                MonitorTable.Cell cell = new MonitorTable.Cell(handles, field);
                this.format(cell);
                ((ArrayList)this.cells.get(row)).add(cell);
            }
        }
    }

    private Node addChild(Node parent, String name) {
        Enumeration<TreeNode> e = parent.children();
        Node child = null;
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            if (!name.equals(n.toString())) continue;
            child = n;
            break;
        }
        if (child == null) {
            child = new Node(name);
            parent.add(child);
        }
        return child;
    }

    private int setRowNumbers(int start, Node node) {
        node.row = start++;
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            start = this.setRowNumbers(start, (Node)e.nextElement());
        }
        return start;
    }

    public void init() {
        if (this.isInitialized) {
            return;
        }
        Enumeration<TreeNode> nodes = this.root.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            Node node = (Node)nodes.nextElement();
            AbstractMonitorView.ChannelHandle ch = node.getChannelHandle();
            if (ch == null) continue;
            ch.setView(node);
        }
        this.isInitialized = true;
    }

    @Override
    public void destroy() {
        if (!this.isInitialized) {
            return;
        }
        Enumeration<TreeNode> nodes = this.root.depthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            Node node = (Node)nodes.nextElement();
            AbstractMonitorView.ChannelHandle ch = node.getChannelHandle();
            if (ch == null) continue;
            ch.setView(null);
        }
        this.isInitialized = false;
    }

    @Override
    public JTable getTable() {
        JTable table = super.getTable();
        JTableHeader header = table.getTableHeader();
        header.setResizingAllowed(true);
        return table;
    }

    @Override
    public JTable makeTable() {
        this.init();
        return new Table(this);
    }

    @Override
    public String getColumnName(int column) {
        return column == 0 ? "Channel" : this.columns.get(column - 1).getTitle();
    }

    public int getHierarchicalColumn() {
        return 0;
    }

    public Object getValueAt(Object node, int column) {
        return column == 0 ? node : this.getValueAt(((Node)node).row, column);
    }

    public boolean isCellEditable(Object node, int column) {
        return column == 0 ? false : this.isCellEditable(((Node)node).getRow(), column);
    }

    public void setValueAt(Object value, Object node, int column) {
        if (column != 0) {
            this.setValueAt(value, ((Node)node).row, column);
        }
    }

    public Object getRoot() {
        return this.treeModel.getRoot();
    }

    public Object getChild(Object parent, int index) {
        return this.treeModel.getChild(parent, index);
    }

    public int getChildCount(Object parent) {
        return this.treeModel.getChildCount(parent);
    }

    public boolean isLeaf(Object node) {
        return this.treeModel.isLeaf(node);
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
        this.treeModel.valueForPathChanged(path, newValue);
    }

    public int getIndexOfChild(Object parent, Object child) {
        return this.treeModel.getIndexOfChild(parent, child);
    }

    public void addTreeModelListener(TreeModelListener l) {
        this.treeModel.addTreeModelListener(l);
    }

    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModel.removeTreeModelListener(l);
    }

    @Override
    protected boolean format(MonitorTable.Cell cell) {
        MonitorTable.Data newData;
        MonitorField field = cell.getField();
        List<AbstractMonitorView.ChannelHandle> handles = cell.getItems();
        switch (handles.size()) {
            case 0: {
                newData = new MonitorTable.Data(field.getTitle(), 0);
                break;
            }
            case 1: {
                newData = this.format(handles.get(0), field);
                break;
            }
            default: {
                ArrayList<MonitorTable.Data> all = new ArrayList<MonitorTable.Data>(handles.size());
                for (AbstractMonitorView.ChannelHandle h : handles) {
                    all.add(this.format(h, field));
                }
                newData = MonitorTable.Data.merge(all);
            }
        }
        if (newData.equals(cell.getData())) {
            return false;
        }
        cell.setData(newData);
        return true;
    }

    private static class Table
    extends JXTreeTable {
        Table(TreeTable model) {
            super((TreeTableModel)model);
        }

        protected void resetDefaultTableCellRendererColors(Component renderer, int row, int column) {
        }
    }

    private class Node
    extends DefaultMutableTreeNode
    implements AbstractMonitorView.ChannelDisplay {
        private int row;
        private AbstractMonitorView.ChannelHandle channelHandle;

        Node(String name) {
            super(name);
        }

        public int getRow() {
            return this.row;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public AbstractMonitorView.ChannelHandle getChannelHandle() {
            return this.channelHandle;
        }

        public void setChannelHandle(AbstractMonitorView.ChannelHandle channelHandle) {
            this.channelHandle = channelHandle;
        }

        @Override
        public void update(AbstractMonitorView.ChannelHandle channelHandle, List<String> attributes) {
            LinkedHashSet<MonitorField> fields = MonitorTable.translateAttributesToFields(attributes);
            int topChangedRow = Integer.MAX_VALUE;
            for (MonitorField field : fields) {
                int col = TreeTable.this.columns.indexOf(field);
                if (col == -1) break;
                for (Node node = this; node != TreeTable.this.root && TreeTable.this.format((MonitorTable.Cell)((ArrayList)TreeTable.this.cells.get(node.row)).get(col + 1)); node = (Node)node.getParent()) {
                    if (node.row >= topChangedRow) continue;
                    topChangedRow = this.row;
                }
            }
            if (topChangedRow < Integer.MAX_VALUE) {
                TreeTable.this.fireTableRowsUpdated(topChangedRow, this.row);
                TreeTable.this.fireChangeEvent(TreeTable.this.CELLS_EVENT);
            }
        }
    }
}

