/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.tree;

import java.util.StringTokenizer;
import javax.swing.tree.TreePath;

public class FTreePath {
    private String[] paths;
    private int length;
    private FTreePath parentPath = null;
    private TreePath treePath;

    public FTreePath(String path) {
        String[] paths = null;
        if (path.trim().equals("")) {
            paths = new String[]{""};
        } else {
            StringTokenizer st = new StringTokenizer(path, "/");
            int tokens = st.countTokens();
            paths = new String[tokens];
            for (int i = 0; i < tokens; ++i) {
                paths[i] = st.nextToken();
            }
        }
        this.init(paths);
    }

    public FTreePath(String[] paths) {
        this.init(paths);
    }

    public FTreePath(FTreePath path) {
        this.init(path.getPath());
    }

    private void init(String[] fullPath) {
        this.length = fullPath.length;
        this.paths = new String[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.paths[i] = fullPath[i];
        }
        this.treePath = new TreePath(this.paths);
    }

    public String getLastPathComponent() {
        return this.paths[this.length - 1];
    }

    public FTreePath getParentPath() {
        if (this.length == 1) {
            return null;
        }
        if (this.parentPath != null) {
            return this.parentPath;
        }
        String[] parentPaths = new String[this.length - 1];
        for (int i = 0; i < this.length - 1; ++i) {
            parentPaths[i] = this.paths[i];
        }
        this.parentPath = new FTreePath(parentPaths);
        return this.parentPath;
    }

    public String[] getPath() {
        return this.paths;
    }

    public String getPathComponent(int index) {
        if (index < 0 || index > this.length - 1) {
            throw new IllegalArgumentException("Illegal index " + index);
        }
        return this.paths[index];
    }

    public int getPathCount() {
        return this.length;
    }

    public boolean isDescendant(FTreePath FTreePath2) {
        return this.treePath().isDescendant(FTreePath2.treePath());
    }

    public FTreePath pathByAddingChild(String child) {
        String[] newPath = new String[this.length + 1];
        for (int i = 0; i < this.length; ++i) {
            newPath[i] = this.paths[i];
        }
        newPath[this.length] = child;
        return new FTreePath(newPath);
    }

    public FTreePath pathByAddingPath(String[] extraPath) {
        int i;
        String[] newPath = new String[this.length + extraPath.length];
        for (i = 0; i < this.length; ++i) {
            newPath[i] = this.paths[i];
        }
        for (i = 0; i < extraPath.length; ++i) {
            newPath[this.length + i] = extraPath[i];
        }
        return new FTreePath(newPath);
    }

    public String toString() {
        String pathName = "";
        for (int i = 0; i < this.getPathCount(); ++i) {
            pathName = pathName + "/" + this.getPathComponent(i);
        }
        return pathName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FTreePath)) {
            return false;
        }
        FTreePath path = (FTreePath)o;
        if (path.getPathCount() != this.getPathCount()) {
            return false;
        }
        for (int i = 0; i < this.getPathCount(); ++i) {
            if (path.getPathComponent(i) == this.getPathComponent(i)) continue;
            return false;
        }
        return true;
    }

    private TreePath treePath() {
        return this.treePath;
    }
}

