/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.dao;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.localdb.statusdb.model.AgentDesc;
import org.lsst.ccs.localdb.statusdb.model.AgentState;
import org.lsst.ccs.localdb.statusdb.model.AlertDesc;
import org.lsst.ccs.localdb.statusdb.model.BaseState;
import org.lsst.ccs.localdb.statusdb.model.InnerStateDesc;
import org.lsst.ccs.localdb.statusdb.model.StatTimeInterval;
import org.lsst.ccs.utilities.logging.Logger;

public class LocaldbFacade {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");

    private LocaldbFacade() {
    }

    public static AgentDesc getAgentDesc(AgentInfo agentInfo, Session sess) {
        String key = agentInfo.getName();
        AgentDesc ad = (AgentDesc)sess.get(AgentDesc.class, (Serializable)((Object)key));
        if (ad == null) {
            ad = new AgentDesc(agentInfo);
            sess.persist((Object)ad);
            log.debug((Object)("Added Agent description for " + key + " : " + ad.getAgentName()));
        }
        return ad;
    }

    public static AlertDesc getAlertDescOrPersist(AgentDesc agentDesc, Alert alert, Session sess) {
        AlertDesc ad = LocaldbFacade.getAlertDesc(agentDesc, alert.getAlertId(), sess);
        if (ad == null) {
            ad = new AlertDesc();
            ad.setAgentDesc(agentDesc);
            ad.setAlertId(alert.getAlertId());
            ad.setAlertDescription(alert.getDescription());
            sess.persist((Object)ad);
            log.debug((Object)("Added Alert description for " + agentDesc.getAgentName() + "/" + alert.getAlertId() + " : " + ad.getAlertId()));
        }
        return ad;
    }

    public static AlertDesc getAlertDesc(AgentDesc agentDesc, String alertId, Session sess) {
        Query q = sess.getNamedQuery("findAlertDesc");
        q.setString("id", alertId).setString("name", agentDesc.getAgentName());
        return (AlertDesc)q.uniqueResult();
    }

    public static InnerStateDesc getInnerStateDesc(AgentInfo ai, String enumClassName, String enumValue, Session sess) {
        Query q = sess.getNamedQuery("findInnerStateDesc");
        q.setString("subsystemName", ai.getName()).setString("enumClassName", enumClassName).setString("enumValue", enumValue);
        InnerStateDesc isd = (InnerStateDesc)q.uniqueResult();
        if (isd == null) {
            isd = new InnerStateDesc();
            AgentDesc ad = LocaldbFacade.getAgentDesc(ai, sess);
            isd.setAgentDesc(ad);
            isd.setEnumClassName(enumClassName);
            isd.setEnumValue(enumValue);
            sess.persist((Object)isd);
            log.debug((Object)("Added Inner State description description for " + isd.toString()));
        }
        return isd;
    }

    public static BaseState getBaseState(StateBundle sb, Session sess) {
        BaseState bs = new BaseState(sb);
        Query q = sess.getNamedQuery("findBaseState").setString("alertSt", bs.getAlertState()).setString("phaseSt", bs.getPhaseState()).setString("commandSt", bs.getCommandState()).setString("operationalSt", bs.getOperationalState()).setString("configurationSt", bs.getConfigState());
        log.debug((Object)("sending query : " + q.getQueryString()));
        BaseState persistedBS = (BaseState)q.uniqueResult();
        if (persistedBS == null) {
            sess.persist((Object)bs);
            log.debug((Object)("Added BaseState description for " + bs.toString()));
            return bs;
        }
        return persistedBS;
    }

    public static AgentState getAgentState(AgentInfo ai, StateBundle sb, Session sess) {
        BaseState bs = LocaldbFacade.getBaseState(sb, sess);
        Map internalStates = sb.getInternalStates();
        HashMap<String, InnerStateDesc> internalStateDescs = new HashMap<String, InnerStateDesc>();
        for (Map.Entry entry : internalStates.entrySet()) {
            internalStateDescs.put((String)entry.getKey(), LocaldbFacade.getInnerStateDesc(ai, (String)entry.getKey(), (String)entry.getValue(), sess));
        }
        Query q = sess.getNamedQuery("findAgentState").setString("subsystemName", ai.getName()).setLong("baseStateId", bs.getId());
        AgentState as = null;
        List l = q.list();
        for (Object o : l) {
            AgentState a = (AgentState)o;
            if (!a.getInnerStates().equals(internalStateDescs)) continue;
            as = a;
            break;
        }
        if (as == null) {
            as = new AgentState();
            as.setAgentDesc(LocaldbFacade.getAgentDesc(ai, sess));
            as.setBaseState(bs);
            as.setInnerStates(internalStateDescs);
            sess.persist((Object)as);
            log.debug((Object)("Added AgentState for " + as.toString()));
        }
        return as;
    }

    public static StatTimeInterval getStatTimeInterval(long binWidth, long dataTime, Session sess) {
        Query statTimeIntervalQuery = sess.getNamedQuery("findStatTimeInterval");
        statTimeIntervalQuery.setLong("binWidth", binWidth);
        statTimeIntervalQuery.setLong("t1", dataTime - binWidth);
        statTimeIntervalQuery.setLong("t2", dataTime);
        StatTimeInterval statTimeInterval = (StatTimeInterval)statTimeIntervalQuery.uniqueResult();
        if (statTimeInterval == null) {
            long statTimeIntervalStart = dataTime / binWidth * binWidth;
            statTimeInterval = new StatTimeInterval(statTimeIntervalStart, binWidth);
            sess.persist((Object)statTimeInterval);
        }
        return statTimeInterval;
    }
}

