/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.trending.timeselection;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeWindow {
    public static final String DATE_PATTERN = "MM/dd/yyyy HH:mm:ss";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
    public static final Pattern EDGE_PATTERN = Pattern.compile("\\s*now\\s*(?:-\\s*(\\d+)\\s*)?");
    private static final String DELIMITER_RE = "\\$";
    private static final String DELIMITER = "$";
    private String name;
    private long lower;
    private long upper;
    private boolean persist;
    private long lastUsed;

    public TimeWindow(String name, long start, long end, boolean persistent) {
        this.set(name, start, end, persistent);
        this.lastUsed = System.currentTimeMillis();
    }

    public TimeWindow(String name, String start, String end, boolean persistent) {
        this(name, TimeWindow.parseEdge(start) / 1000L, TimeWindow.parseEdge(end) / 1000L, persistent);
    }

    public TimeWindow(String name) {
        this.name = name;
    }

    void set(String name, long start, long end, boolean persistent) {
        this.name = name;
        this.lower = start * 1000L;
        this.upper = end * 1000L;
        if (this.upper > 0L && this.lower <= 0L || this.getLength() <= 0L) {
            throw new IllegalArgumentException();
        }
        this.persist = persistent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isFixed() {
        return this.lower > 0L && this.upper > 0L;
    }

    public boolean isLowerEdgeFixed() {
        return this.lower > 0L;
    }

    public boolean isUpperEdgeFixed() {
        return this.upper > 0L;
    }

    public long getLowerEdgeDelay() {
        return this.lower > 0L ? System.currentTimeMillis() - this.lower : -this.lower;
    }

    public long getUpperEdgeDelay() {
        return this.upper > 0L ? System.currentTimeMillis() - this.upper : -this.upper;
    }

    public long getLowerEdge() {
        return this.getLowerEdge(System.currentTimeMillis());
    }

    public long getUpperEdge() {
        return this.getUpperEdge(System.currentTimeMillis());
    }

    public long getLowerEdge(long currentTime) {
        return this.lower > 0L ? this.lower : currentTime + this.lower;
    }

    public long getUpperEdge(long currentTime) {
        return this.upper > 0L ? this.upper : currentTime + this.upper;
    }

    public String getLowerEdgeString() {
        if (this.lower > 0L) {
            return DATE_FORMAT.format(new Date(this.lower));
        }
        if (this.lower == 0L) {
            return "now";
        }
        return "now - " + -this.lower / 1000L;
    }

    public String getUpperEdgeString() {
        if (this.upper > 0L) {
            return DATE_FORMAT.format(new Date(this.upper));
        }
        if (this.upper == 0L) {
            return "now";
        }
        return "now - " + -this.upper / 1000L;
    }

    public void setLowerEdge(String edge) {
        this.lower = TimeWindow.parseEdge(edge);
    }

    public void setUpperEdge(String edge) {
        this.upper = TimeWindow.parseEdge(edge);
    }

    public long getLength() {
        if (this.upper > 0L) {
            return this.upper - this.lower;
        }
        if (this.lower > 0L) {
            return System.currentTimeMillis() + this.upper - this.lower;
        }
        return this.upper - this.lower;
    }

    public boolean isPersistent() {
        return this.persist;
    }

    public void setPersistent(boolean persistent) {
        this.persist = persistent;
    }

    public long getLastUseTime() {
        return this.lastUsed;
    }

    public void touch() {
        this.lastUsed = System.currentTimeMillis();
    }

    public String toString() {
        return this.name + " : " + this.getLowerEdgeString() + " through " + this.getUpperEdgeString();
    }

    public String toCompressedString() {
        return this.name + DELIMITER + this.getLowerEdgeString() + DELIMITER + this.getUpperEdgeString();
    }

    public static long parseEdge(String edgeString) {
        try {
            Date d = DATE_FORMAT.parse(edgeString);
            return d.getTime();
        }
        catch (ParseException d) {
            try {
                Matcher m = EDGE_PATTERN.matcher(edgeString);
                m.matches();
                String delay = m.group(1);
                return delay == null ? 0L : -Long.parseLong(delay) * 1000L;
            }
            catch (IllegalStateException | NumberFormatException x) {
                throw new IllegalArgumentException(x);
            }
        }
    }

    public static TimeWindow parseCompressedString(String s) {
        String[] tokens = s.split(DELIMITER_RE);
        try {
            return new TimeWindow(tokens[0], tokens[1], tokens[2], true);
        }
        catch (RuntimeException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public static Comparator<TimeWindow> compareByName() {
        return new Comparator<TimeWindow>(){

            @Override
            public int compare(TimeWindow o1, TimeWindow o2) {
                return o1.name.compareTo(o2.name);
            }
        };
    }

    public static Comparator compareByTime() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return (int)Math.signum(((TimeWindow)o2).getLastUseTime() - ((TimeWindow)o1).getLastUseTime());
            }
        };
    }
}

