/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.util.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.stream.Collectors;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.gconsole.util.tree.SModel;
import org.lsst.ccs.gconsole.util.tree.SNode;
import org.lsst.ccs.gconsole.util.tree.TreeUtil;

public class STree<T>
extends JTree
implements Savable {
    public STree() {
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
    }

    public STree(SModel<T> model) {
        super(model);
        this.setRootVisible(false);
        this.getSelectionModel().setSelectionMode(1);
    }

    @Override
    public SNode<T> getLastSelectedPathComponent() {
        return (SNode)super.getLastSelectedPathComponent();
    }

    @Override
    public SModel<T> getModel() {
        return (SModel)super.getModel();
    }

    public void expandLevel(int level) {
        Object root = ((SModel)this.getModel()).getRoot();
        if (root != null) {
            this.expandLevel(level - 1, 0, (SNode<T>)root, new TreePath(root));
        }
    }

    private void expandLevel(int targetLevel, int currentLevel, SNode<T> node, TreePath path) {
        if (targetLevel == currentLevel) {
            if (!node.isLeaf()) {
                this.expandPath(path);
            }
        } else {
            Enumeration<TreeNode> e = node.children();
            if (!e.hasMoreElements()) {
                TreePath p = path.getParentPath();
                if (p != null) {
                    this.expandPath(p);
                }
            } else {
                ++currentLevel;
                while (e.hasMoreElements()) {
                    SNode child = (SNode)e.nextElement();
                    this.expandLevel(targetLevel, currentLevel, child, path.pathByAddingChild(child));
                }
            }
        }
    }

    public T getSelectedUserObject() {
        Object node = this.getLastSelectedPathComponent();
        return node == null ? null : (T)((SNode)node).getUserObject();
    }

    @Override
    public void restore(Serializable descriptor) {
        String[] expansionState;
        if (!(descriptor instanceof Descriptor)) {
            return;
        }
        Descriptor desc = (Descriptor)descriptor;
        for (String path : expansionState = desc.getExpansionState()) {
            TreePath tp = ((SModel)this.getModel()).getPath(path);
            if (tp == null) continue;
            this.expandPath(tp);
        }
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor();
        ArrayList<TreePath> expandedPaths = TreeUtil.saveExpansionState(this);
        String[] expansionState = expandedPaths.stream().map(p -> ((SNode)p.getLastPathComponent()).getPathAsString()).collect(Collectors.toList()).toArray(new String[expandedPaths.size()]);
        desc.setExpansionState(expansionState);
        return desc;
    }

    public static class Descriptor
    implements Serializable {
        private String[] expansionState;

        public String[] getExpansionState() {
            return this.expansionState;
        }

        public void setExpansionState(String[] expansionState) {
            this.expansionState = expansionState;
        }
    }
}

