/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.Agent;
import org.lsst.ccs.RaisedAlertBookkeeper;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusClearedAlert;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusRaisedAlert;
import org.lsst.ccs.bus.states.AgentState;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AlertHandler;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.framework.TreeWalkerUtils;

public final class AlertService
implements HasLifecycle {
    private final Agent agent;
    private final RaisedAlertBookkeeper raisedAlertBookkeeper = new RaisedAlertBookkeeper();
    private final List<ClearAlertHandler> clearAlertHandlers = new ArrayList<ClearAlertHandler>();
    private final Object alertLock = new Object();
    private final int alertAccumulationPeriod = 2000;
    private final Map<String, AlertRunnable> alertRunnables = new HashMap<String, AlertRunnable>();
    private final Map<String, ScheduledFuture> alertTasks = new HashMap<String, ScheduledFuture>();

    public AlertService(Agent a) {
        this.agent = a;
        ComponentLookup lookup = a.getComponentLookup();
        lookup.addComponentNodeToLookup(lookup.getTopComponentNode().getKey(), new ComponentNode(null, "alertService", (Object)this));
    }

    @Override
    public void postInit() {
        TreeWalkerUtils.proceduralWalk(this.agent.getComponentLookup(), null, AlertHandler.class, ah -> {
            if (ah instanceof ClearAlertHandler) {
                this.addClearAlertHandler((ClearAlertHandler)ah);
            }
        }, null);
    }

    @Override
    public void postShutdown() {
        this.clearAlertHandlers.clear();
    }

    @Deprecated
    public void addClearAlertHandler(ClearAlertHandler handler) {
        if (this.clearAlertHandlers.contains(handler)) {
            System.out.println("WARNING: The clear alert handler has already been added. Please remove any calls to \"addClearAlertHandler\" as the framework is picking them up from the lookup tree.");
        }
        this.clearAlertHandlers.add(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void raiseAlert(Alert alert, AlertState severity, String cause) {
        long ts = System.currentTimeMillis();
        Object object = this.alertLock;
        synchronized (object) {
            String alertId = alert.getAlertId();
            ScheduledFuture task = this.alertTasks.get(alertId);
            if (task == null || task.isDone()) {
                this.raiseAlertAndAccumulate(alert, severity, ts, cause);
            } else if (this.alertRunnables.get(alertId).severity != severity) {
                if (task.cancel(false)) {
                    this.alertRunnables.get(alertId).updateBookkeeperAndSendStatusAlert();
                }
                this.raiseAlertAndAccumulate(alert, severity, ts, cause);
            } else {
                this.alertRunnables.get(alertId).accumulate(cause);
            }
        }
    }

    private void raiseAlertAndAccumulate(Alert alert, AlertState severity, long ts, String cause) {
        new AlertRunnable(alert, severity, ts, cause).updateBookkeeperAndSendStatusAlert();
        AlertRunnable r = new AlertRunnable(alert, severity, ts, cause);
        ScheduledFuture task = this.agent.getScheduler().schedule((Runnable)r, 2000L, TimeUnit.MILLISECONDS);
        this.alertRunnables.put(alert.getAlertId(), r);
        this.alertTasks.put(alert.getAlertId(), task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Clear alerts", type=Command.CommandType.ACTION)
    public String[] clearAlerts(String ... alertId) {
        Object object = this.alertLock;
        synchronized (object) {
            String summary;
            ArrayList<String> clearedAlerts = new ArrayList<String>();
            for (String id : alertId) {
                ScheduledFuture alertTask = this.alertTasks.get(id);
                if (alertTask != null) {
                    alertTask.cancel(true);
                    this.alertTasks.remove(id);
                }
                boolean clearAlert = true;
                RaisedAlertHistory raisedAlert = this.raisedAlertBookkeeper.getRaisedAlert(id);
                if (raisedAlert != null) {
                    for (ClearAlertHandler handler : this.clearAlertHandlers) {
                        ClearAlertHandler.ClearAlertCode code = handler.canClearAlert(raisedAlert.getLatestAlert());
                        if (code == ClearAlertHandler.ClearAlertCode.CLEAR_ALERT) {
                            clearAlert = true;
                            continue;
                        }
                        if (code != ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT) continue;
                        clearAlert = false;
                        break;
                    }
                }
                if (!clearAlert) continue;
                this.raisedAlertBookkeeper.clearAlert(id);
                clearedAlerts.add(id);
            }
            String[] clearedIds = new String[clearedAlerts.size()];
            if (!clearedAlerts.isEmpty()) {
                clearedIds = clearedAlerts.toArray(clearedIds);
                AlertState globalSeverity = this.raisedAlertBookkeeper.getAlertState();
                if (globalSeverity == AlertState.WARNING && this.agent.isInState((Enum)AlertState.ALARM)) {
                    this.agent.updateInternalState(new AgentState[]{AlertState.WARNING, OperationalState.ENGINEERING_OK});
                } else if (globalSeverity == AlertState.NOMINAL && !this.agent.isInState((Enum)AlertState.NOMINAL)) {
                    this.agent.updateInternalState(new AgentState[]{AlertState.NOMINAL, OperationalState.ENGINEERING_OK});
                }
                StatusClearedAlert clearedStatus = new StatusClearedAlert(clearedIds, this.agent.getState(), this.getRaisedAlertSummary());
                this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)clearedStatus);
            }
            if (clearedIds.length > 0) {
                summary = "Cleared Alert Id" + (clearedIds.length > 1 ? "s" : "") + " (";
                for (int i = 0; i < clearedIds.length; ++i) {
                    summary = summary + clearedIds[i];
                    if (i >= clearedIds.length - 1) continue;
                    summary = summary + ", ";
                }
                summary = summary + ")";
            } else {
                summary = "Attempt to clear alerts, but no Alerts were cleared";
            }
            this.agent.getLogger().info((Object)(summary + " the resulting Alert State is " + this.raisedAlertBookkeeper.getAlertState().name()));
            return clearedIds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Clear all alerts", type=Command.CommandType.ACTION)
    public String[] clearAllAlerts() {
        Object object = this.alertLock;
        synchronized (object) {
            Set alerts = this.raisedAlertBookkeeper.getAllRaisedAlertHistories();
            String[] alertId = new String[alerts.size()];
            int count = 0;
            for (RaisedAlertHistory alert : alerts) {
                alertId[count++] = alert.getLatestAlert().getAlertId();
            }
            return this.clearAlerts(alertId);
        }
    }

    private Level getLogLevelForAlertState(AlertState state) {
        if (state == AlertState.ALARM) {
            return Level.SEVERE;
        }
        if (state == AlertState.WARNING) {
            return Level.WARNING;
        }
        return Level.INFO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(description="Get the Raised Alert Summary", type=Command.CommandType.QUERY)
    public RaisedAlertSummary getRaisedAlertSummary() {
        Object object = this.alertLock;
        synchronized (object) {
            return this.raisedAlertBookkeeper;
        }
    }

    private final class AlertRunnable
    implements Runnable {
        private final Alert alert;
        private final AlertState severity;
        private String cause;
        private long ts;
        private int count = 0;

        private AlertRunnable(AlertRunnable other) {
            this(other.alert, other.severity, other.ts, other.cause);
        }

        private AlertRunnable(Alert alert, AlertState severity, long timestamp, String cause) {
            this.alert = alert;
            this.severity = severity;
            this.ts = timestamp;
            this.accumulate(cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void accumulate(String cause) {
            Object object = AlertService.this.alertLock;
            synchronized (object) {
                this.cause = cause;
                ++this.count;
            }
        }

        @Override
        public void run() {
            this.updateBookkeeperAndSendStatusAlert();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateBookkeeperAndSendStatusAlert() {
            Object object = AlertService.this.alertLock;
            synchronized (object) {
                if (this.count <= 0) {
                    return;
                }
                RaisedAlertHistory raisedAlert = AlertService.this.raisedAlertBookkeeper.raiseAlert(this.alert, this.severity, this.ts, this.cause, this.count);
                AlertState globalSeverity = AlertService.this.raisedAlertBookkeeper.getAlertState();
                if (globalSeverity == AlertState.ALARM && !AlertService.this.agent.isInState((Enum)AlertState.ALARM)) {
                    AlertService.this.agent.updateInternalState(new AgentState[]{AlertState.ALARM, OperationalState.ENGINEERING_FAULT});
                } else if (globalSeverity == AlertState.WARNING && AlertService.this.agent.getState(AlertState.class).compareTo(AlertState.WARNING) < 0) {
                    AlertService.this.agent.updateInternalState(new AgentState[]{AlertState.WARNING});
                }
                AlertService.this.agent.getLogger().log(AlertService.this.getLogLevelForAlertState(this.severity), "Raised Alert " + this.alert.getAlertId() + "(" + this.alert.getDescription() + ") " + this.count + " times. Last cause : \"" + this.cause + "\". Overall AlertState=" + globalSeverity.name(), (Object)"");
                StatusRaisedAlert statusAlert = new StatusRaisedAlert(this.alert, raisedAlert.getLatestAlertCause(), AlertService.this.agent.getState(), new RaisedAlertSummary(AlertService.this.getRaisedAlertSummary()));
                AlertService.this.agent.getMessagingAccess().sendStatusMessage((StatusMessage)statusAlert);
            }
        }
    }
}

