/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.plots;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.lsst.ccs.gconsole.Plugin;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.plugins.plots.PlotsListener;
import org.lsst.ccs.messaging.StatusMessageListener;

@Plugin(name="LSST Plots Plugin", description="Allows displaying AIDA plots published on the status bus.")
public class LsstPlotsPlugin
extends ConsolePlugin {
    public static final String AUTO_START = "autoStart";
    private final Action plotsAction = new AbstractAction("Plots"){

        @Override
        public void actionPerformed(ActionEvent e) {
            LsstPlotsPlugin.this.setEnabled((Boolean)this.getValue("SwingSelectedKey"));
        }
    };
    private PlotsListener plotListener;

    public LsstPlotsPlugin() {
        this.plotsAction.putValue("SwingSelectedKey", false);
    }

    @Override
    public synchronized void initialize() {
        this.getServices().addMenu(this.plotsAction, "400: CCS Tools :-1:7");
        this.getServices().addProperty(AUTO_START, false);
        this.getServices().addPreference(new String[]{"LSST", "AIDA Plots"}, null, "${autoStart}Start on console sturtup.");
    }

    @Override
    public void start() {
        boolean enable = (Boolean)this.getServices().getProperty(AUTO_START);
        if (enable) {
            this.setEnabled(true);
        }
    }

    public synchronized void setEnabled(boolean enable) {
        this.plotsAction.putValue("SwingSelectedKey", enable);
        if (enable) {
            this.plotListener = new PlotsListener();
            this.getConsole().getMessagingAccess().addStatusMessageListener((StatusMessageListener)this.plotListener);
        } else {
            this.getConsole().getMessagingAccess().removeStatusMessageListener((StatusMessageListener)this.plotListener);
            this.plotListener = null;
        }
    }
}

