/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.description;

import java.util.HashMap;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.groovy.GroovyComponentNodeFactory;

public class ComponentNodeBuilder {
    public static String alias;
    private static final HashMap<String, ComponentNodeFactory> factories;

    static {
        factories = new HashMap();
        ComponentNodeBuilder.registerComponentNodeFactory(new GroovyComponentNodeFactory());
    }

    public static void registerComponentNodeFactory(ComponentNodeFactory factory) {
        factories.put(factory.getProtocol(), factory);
    }

    public static ComponentLookup buildComponentNode(String fullDescription) {
        return ComponentNodeBuilder.buildComponentNode(fullDescription, null);
    }

    public static ComponentLookup buildComponentNode(String fullDescription, String alias) {
        ComponentNodeFactory factory;
        ComponentNodeBuilder.alias = alias;
        String descriptionProtocol = "groovy";
        String descriptionString = fullDescription;
        if (fullDescription.contains(":")) {
            descriptionProtocol = fullDescription.substring(0, fullDescription.indexOf(58));
            descriptionString = fullDescription.substring(fullDescription.indexOf(58) + 1);
        }
        if ((factory = factories.get(descriptionProtocol)) == null) {
            throw new IllegalArgumentException("There is no registered ComponentNodeFactory for protocol " + descriptionProtocol);
        }
        return factory.buildComponentNode(descriptionString);
    }

    public static interface ComponentNodeFactory {
        public ComponentLookup buildComponentNode(String var1);

        public String getProtocol();
    }
}

