/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.statusdb.utils;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.boot.model.naming.ImplicitNamingStrategy;
import org.hibernate.cfg.Configuration;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.localdb.statusdb.model.CCSNamingStrategy;
import org.lsst.ccs.utilities.logging.Logger;

public class StatusdbUtils {
    private static Configuration cfg;
    private static SessionFactory fac;
    protected static Logger log;

    public static synchronized SessionFactory getSessionFactory(Properties inputProperties) {
        if (cfg == null) {
            String hibernateConfigFile = System.getProperty("org.lsst.ccs.localdb.hibernate.config.file", "hibernate-tm.cfg.xml");
            String propertiesFile = System.getProperty("org.lsst.ccs.localdb.hibernate.properties.file", "statusPersister.properties");
            try {
                URL configFileFullURL = BootstrapResourceUtils.getResourceURL((String)hibernateConfigFile);
                log.info((Object)("hibernate config from " + configFileFullURL));
                cfg = new Configuration().configure(configFileFullURL);
            }
            catch (MalformedURLException ex) {
                log.severe((Object)ex);
                throw new RuntimeException("Could not configur Hibernate", ex);
            }
            log.info((Object)("hibernate properties from " + propertiesFile));
            cfg.setImplicitNamingStrategy((ImplicitNamingStrategy)new CCSNamingStrategy());
            Properties cfgProps = new Properties();
            try {
                cfgProps.load(BootstrapResourceUtils.getBootstrapPropertiesInputStream((String)propertiesFile, StatusdbUtils.class));
            }
            catch (IOException ioe) {
                throw new RuntimeException("Could not load Hibernate properties", ioe);
            }
            cfg = cfg.addProperties(cfgProps);
            if (inputProperties != null) {
                log.info((Object)"adding input properties");
                cfg = cfg.addProperties(inputProperties);
            }
            Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb");
            Properties finalP = cfg.getProperties();
            log.debug((Object)"*** Working with connection properties ");
            for (Object key : finalP.keySet()) {
                String skey = (String)key;
                if (!skey.startsWith("hibernate")) continue;
                log.debug((Object)(skey + ": " + finalP.getProperty(skey)));
            }
            log.debug((Object)"*********************************");
        }
        if (fac == null) {
            fac = cfg.buildSessionFactory();
        }
        return fac;
    }

    public static synchronized void closeSessionFactory() {
        if (fac != null) {
            fac.close();
        }
        fac = null;
        cfg = null;
    }

    static {
        log = Logger.getLogger((String)"org.lsst.ccs.localdb");
    }
}

