/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.node_building;

import java.util.Map;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;

public class ModuleWithMapParms
extends Module {
    int min;
    int max;

    public ModuleWithMapParms(String name, Map<String, Integer> map) {
        super(name);
        this.setMinMax(map);
    }

    final void setMin(int min) {
        if (min < 0) {
            throw new IllegalArgumentException("min should be positive");
        }
        this.min = min;
    }

    final void setMax(int max) {
        if (max > 2048) {
            throw new IllegalArgumentException("max should be less than 2048");
        }
        this.max = max;
    }

    @ConfigChanger
    public final void setMinMax(Map<String, Integer> changes) {
        int valMin = changes.get("min");
        int valMax = changes.get("max");
        if (valMin < 10) {
            throw new IllegalArgumentException("min must be >= 10");
        }
        if (valMax > 100) {
            throw new IllegalArgumentException("max must be <= 100");
        }
        if (valMin > valMax) {
            throw new IllegalArgumentException("max less that min");
        }
        this.setMin(valMin);
        this.setMax(valMax);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModuleWithMapParms{");
        sb.append("min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append('}');
        return sb.toString();
    }
}

