/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.TracerModule;
import org.lsst.ccs.framework.TreeWalkerDiag;

public class TracerHardwareController
extends TracerModule
implements HardwareController {
    @ConfigurationParameter
    public volatile boolean failCheckHardware;
    @ConfigurationParameter
    public volatile boolean failStopped;
    @ConfigurationParameter
    public volatile boolean supportChildren;
    @ConfigurationParameter
    public volatile boolean stopChecking;
    @ConfigurationParameter
    public int checks;
    @ConfigurationParameter
    public int checkStarts;
    @ConfigurationParameter
    public int checkStops;
    private volatile boolean isTicking = false;
    @ConfigurationParameter(isFinal=true)
    private int parameter;

    public TracerHardwareController(String name, int tickMillis, boolean failsOnStart, boolean failsStop, boolean controlsChildren, boolean stopsChecks) {
        super(name, tickMillis);
        this.failCheckHardware = failsOnStart;
        this.failStopped = failsStop;
        this.supportChildren = controlsChildren;
        this.stopChecking = stopsChecks;
        this.parameter = 0;
    }

    public TracerHardwareController(String name, boolean failsOnStart, boolean failsStop, boolean controlsChildren, boolean stopsChecks) {
        super(name, 1000);
        this.failCheckHardware = failsOnStart;
        this.failStopped = failsStop;
        this.supportChildren = controlsChildren;
        this.stopChecking = stopsChecks;
        this.parameter = 0;
    }

    @Override
    public void tick() {
        this.isTicking = true;
    }

    public boolean isTicking() {
        return this.isTicking;
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        ++this.checks;
        if (this.failCheckHardware) {
            throw new HardwareException(this.stopChecking, "blocked");
        }
        if (this.supportChildren) {
            return TreeWalkerDiag.HANDLING_CHILDREN;
        }
        if (this.stopChecking) {
            return TreeWalkerDiag.STOP;
        }
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() throws HardwareException {
        ++this.checkStarts;
        if (this.failCheckHardware) {
            throw new HardwareException(this.stopChecking, "not started");
        }
    }

    public void checkStopped() throws HardwareException {
        ++this.checkStops;
        if (this.failStopped) {
            throw new HardwareException(this.stopChecking, "not stopped");
        }
    }

    @Command(description="repairs a  hardware that refuses to start", type=Command.CommandType.SIGNAL)
    public void repairHardware() {
        this.failCheckHardware = false;
    }

    @Command(description="returns the annotated parameter")
    public int getParameter() {
        return this.parameter;
    }

    @Command(description="stops a blocked hardware", type=Command.CommandType.SIGNAL)
    public void stopHardware() {
        this.failStopped = false;
    }
}

