/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.framework.TracerHardwareController;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.layer.MessagingLayerTest;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

@RunWith(value=Parameterized.class)
public class StartupOkTest
extends CcsTestCaseTemplate {
    @Parameterized.Parameters(name="{0}")
    public static List<String> getTransportProtocols() {
        return MessagingLayerTest.getTransportProtocols();
    }

    public StartupOkTest(String transport) {
        super(transport);
    }

    @Test
    public void testStopAndWaitFail() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"startupOk");
        TracerHardwareController hc1 = (TracerHardwareController)((Object)s.getLookup().getComponentByName("hc1"));
        Assert.assertTrue((!hc1.isTicking() ? 1 : 0) != 0);
        s.start();
        s.switchToEngineeringMode();
        Thread.sleep(500L);
        Assert.assertTrue((boolean)hc1.isTicking());
        ArrayList<TracerHardwareController> listOfHC = new ArrayList<TracerHardwareController>();
        listOfHC.add((TracerHardwareController)((Object)s.getLookup().getComponentByName("hc1")));
        listOfHC.add((TracerHardwareController)((Object)s.getLookup().getComponentByName("hc1A")));
        listOfHC.add((TracerHardwareController)((Object)s.getLookup().getComponentByName("hc1B")));
        listOfHC.add((TracerHardwareController)((Object)s.getLookup().getComponentByName("hc2")));
        listOfHC.add((TracerHardwareController)((Object)s.getLookup().getComponentByName("hc2A")));
        listOfHC.add((TracerHardwareController)((Object)s.getLookup().getComponentByName("hc2B")));
        Assert.assertTrue((s.isInState((Enum)OperationalState.ENGINEERING_OK) && s.isInState((Enum)AlertState.NOMINAL) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s.isInState((Enum)PhaseState.OPERATIONAL));
        for (TracerHardwareController hc : listOfHC) {
            Assert.assertTrue((hc.starts == 1 ? 1 : 0) != 0);
            Assert.assertTrue((hc.postAction == 1 ? 1 : 0) != 0);
            Assert.assertTrue((hc.tickStarts == 1 ? 1 : 0) != 0);
            Assert.assertTrue((hc.checkStarts == 0 ? 1 : 0) != 0);
            if (hc.getName().equals("hc2A") || hc.getName().equals("hc2B")) {
                Assert.assertEquals((long)0L, (long)hc.checks);
                continue;
            }
            Assert.assertEquals((long)1L, (long)hc.checks);
        }
        s.shutdown();
    }
}

