/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.Agent;
import org.lsst.ccs.SystemStateException;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.messaging.BusMessageFilter;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationStateTest
extends CcsTestCaseTemplate {
    private static final String descPath = "testConfigurationStates";
    private NodeModularSubsystem s;
    private Agent agent;
    private ConcurrentMessagingUtils cmu;

    @Before
    public void init() throws Exception {
        this.agent = new Agent("console", AgentInfo.AgentType.CONSOLE);
        this.agent.start();
        this.cmu = new ConcurrentMessagingUtils(this.agent.getMessagingAccess());
    }

    @After
    public void tearDown() throws Exception {
        this.s.shutdown();
        this.agent.shutdown();
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testStartWithNoConfiguration() throws Exception {
        this.s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        Configurable main = (Configurable)this.s.getLookup().getComponentByName("main");
        Future<StatusMessage> future = this.startListeningForConfigurationInfo();
        this.s.start();
        while (!this.agent.getMessagingAccess().getAgentPresenceManager().agentExists(this.s.getName())) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)this.s.getState(ConfigurationState.class));
        ConfigurationInfo ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:]", (Object)ci.getConfigurationName());
        Map currentValues = ci.getCurrentValuesForCategory("catA");
        Assert.assertEquals((long)2L, (long)currentValues.size());
        Assert.assertEquals((Object)"0", currentValues.get("main//confVal1"));
        Assert.assertEquals((Object)"0", currentValues.get("son//confVal1"));
        future = this.startListeningForConfigurationInfo();
        main.change("confVal0", (Object)1);
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)this.s.getState(ConfigurationState.class));
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)"testConfigurationStates[*,catA:,catB:]", (Object)ci.getConfigurationName());
        try {
            this.s.switchToNormalMode();
            Assert.fail();
        }
        catch (SystemStateException systemStateException) {
            // empty catch block
        }
        currentValues = ci.getCurrentValuesForCategory("");
        Assert.assertEquals((long)4L, (long)currentValues.size());
        Assert.assertEquals((Object)"1", currentValues.get("main//confVal0"));
        Assert.assertEquals((Object)"0", currentValues.get("son//confVal0"));
        Assert.assertEquals((Object)"1000", currentValues.get("main//tickMillis"));
        Assert.assertEquals((Object)"1000", currentValues.get("son//tickMillis"));
        future = this.startListeningForConfigurationInfo();
        this.s.saveAllChanges();
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)this.s.getState(ConfigurationState.class));
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:]", (Object)ci.getConfigurationName());
        currentValues = ci.getCurrentValuesForComponent("main");
        Assert.assertEquals((long)4L, (long)currentValues.size());
        Assert.assertEquals((Object)"1000", currentValues.get("main//tickMillis"));
        Assert.assertEquals((Object)"1", currentValues.get("main//confVal0"));
        Assert.assertEquals((Object)"0", currentValues.get("main//confVal1"));
        Assert.assertEquals((Object)"0", currentValues.get("main//confVal2"));
        future = this.startListeningForConfigurationInfo();
        main.change("confVal1", (Object)1);
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)this.s.getState(ConfigurationState.class));
        Assert.assertEquals((Object)"testConfigurationStates[,catA:*,catB:]", (Object)ci.getConfigurationName());
        future = this.startListeningForConfigurationInfo();
        main.change("confVal2", (Object)1);
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)this.s.getState(ConfigurationState.class));
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)"testConfigurationStates[,catA:*,catB:*]", (Object)ci.getConfigurationName());
        Assert.assertTrue((boolean)ci.hasChanges());
        future = this.startListeningForConfigurationInfo();
        this.s.saveChangesForCategoriesAs(new String[]{"catB:confB1"});
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)this.s.getState(ConfigurationState.class));
        Assert.assertEquals((Object)"testConfigurationStates[,catA:*,catB:confB1]", (Object)ci.getConfigurationName());
        Assert.assertTrue((boolean)ci.hasChanges());
        Assert.assertEquals((Object)"1", (Object)ci.getCurrentValueForParameter("main//confVal1"));
        future = this.startListeningForConfigurationInfo();
        this.s.saveChangesForCategories(new String[]{"catA"});
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)this.s.getState(ConfigurationState.class));
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:confB1]", (Object)ci.getConfigurationName());
        Assert.assertFalse((boolean)ci.hasChanges());
        future = this.startListeningForConfigurationInfo();
        main.change("confVal2", (Object)9);
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        System.out.println(" status : " + ci.getAllParameterInfo());
        Assert.assertEquals((long)1L, (long)ci.getLatestChanges().size());
        Assert.assertEquals((Object)"9", (Object)((ConfigurationParameterInfo)ci.getLatestChanges().get(0)).getCurrentValue());
        future = this.startListeningForConfigurationInfo();
        this.s.saveAllChanges();
        future.get(1L, TimeUnit.SECONDS).getObject();
        future = this.startListeningForConfigurationInfo();
        main.submitChange("confVal2", (Object)8);
        main.submitChange("confVal1", (Object)2);
        this.s.commitBulkChange();
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)ci.getConfigurationState());
        Assert.assertEquals((long)2L, (long)ci.getLatestChanges().size());
        Assert.assertEquals((Object)"testConfigurationStates[,catA:*,catB:confB1*]", (Object)ci.getConfigurationName());
        future = this.startListeningForConfigurationInfo();
        this.s.dropChangesForCategories(new String[]{"catA"});
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)ci.getConfigurationState());
        Assert.assertEquals((long)1L, (long)ci.getLatestChanges().size());
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:confB1*]", (Object)ci.getConfigurationName());
        future = this.startListeningForConfigurationInfo();
        this.s.dropAllChanges();
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)ci.getConfigurationState());
        Assert.assertEquals((long)1L, (long)ci.getLatestChanges().size());
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:confB1]", (Object)ci.getConfigurationName());
        future = this.startListeningForConfigurationInfo();
        this.s.loadConfiguration(new String[0]);
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)ci.getConfigurationState());
        Assert.assertEquals((long)1L, (long)ci.getLatestChanges().size());
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:]", (Object)ci.getConfigurationName());
        future = this.startListeningForConfigurationInfo();
        this.s.loadCategories(new String[]{"catB:confB1"});
        ci = (ConfigurationInfo)future.get(1L, TimeUnit.SECONDS).getObject();
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)ci.getConfigurationState());
        Assert.assertEquals((long)1L, (long)ci.getLatestChanges().size());
        Assert.assertEquals((Object)"testConfigurationStates[,catA:,catB:confB1]", (Object)ci.getConfigurationName());
        this.s.switchToNormalMode();
        Assert.assertEquals((Object)this.s.getState(OperationalState.class), (Object)OperationalState.NORMAL);
    }

    private Future<StatusMessage> startListeningForConfigurationInfo() {
        return this.cmu.startListeningForStatusBusMessage((Predicate)BusMessageFilter.embeddedObjectClass(ConfigurationInfo.class).and(BusMessageFilter.messageOrigin((String)this.s.getName())));
    }
}

