/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Properties;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.CategorizedConfigurableModule;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationLoadingWithCategoriesTest
extends CcsTestCaseTemplate {
    private static final String descPath = "simulationWithCategories";
    private WriterProvider writerProvider;

    @Before
    public void init() {
        this.writerProvider = LocalConfigurationProxy.getWriterProvider();
    }

    @After
    public void tearDown() {
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testConfigurationOperationSequence() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        String tagName = s.getTag();
        s.start();
        CategorizedConfigurableModule mainModule = (CategorizedConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", "0");
        mainModule.change("confVal1", "1");
        mainModule.change("confVal2", "2");
        s.saveAllChanges();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])mainModule.getConfValues());
        Properties props = this.writerProvider.getConfigurationProperties("", tagName, "");
        Assert.assertEquals((String)"default properties file size : ", (long)0L, (long)props.size());
        props = this.writerProvider.getConfigurationProperties("", tagName, "catA");
        Assert.assertEquals((String)"catA: properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        props = this.writerProvider.getConfigurationProperties("", tagName, "catB");
        Assert.assertEquals((String)"catB: properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        s.shutdown();
        System.out.println("Restart subsystem");
        s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        mainModule = (CategorizedConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        s.start();
        Thread.sleep(200L);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", "3");
        s.saveChangesForCategoriesAs(new String[]{"D3", "catA:A1", "catB:B2"});
        props = this.writerProvider.getConfigurationProperties("D3", tagName, "");
        Assert.assertEquals((String)"D3 file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"3", (Object)props.getProperty("main//confVal0"));
        props = this.writerProvider.getConfigurationProperties("A1", tagName, "catA");
        Assert.assertEquals((String)"catA:A1 file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"1", (Object)props.getProperty("main//confVal1"));
        props = this.writerProvider.getConfigurationProperties("B2", tagName, "catB");
        Assert.assertEquals((String)"catB:B2 file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        Assert.assertArrayEquals((int[])new int[]{3, 1, 2}, (int[])mainModule.getConfValues());
        mainModule.change("confVal2", "0");
        s.saveChangesForCategoriesAs(new String[]{"catB:B0"});
        props = this.writerProvider.getConfigurationProperties("B0", tagName, "catB");
        Assert.assertEquals((String)"catB:B0 properties file size : ", (long)0L, (long)props.size());
        Assert.assertArrayEquals((int[])new int[]{3, 1, 0}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", "7");
        s.saveAllChanges();
        props = this.writerProvider.getConfigurationProperties("D3", tagName, "");
        Assert.assertEquals((String)"D3 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"7", (Object)props.getProperty("main//confVal0"));
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", "0");
        mainModule.change("confVal1", "4");
        mainModule.change("confVal2", "2");
        s.saveChangesForCategoriesAs(new String[]{"D0", "catA:A4", "catB:B2"});
        props = this.writerProvider.getConfigurationProperties("D0", tagName, "");
        Assert.assertEquals((String)"D0 properties file size : ", (long)0L, (long)props.size());
        props = this.writerProvider.getConfigurationProperties("A4", tagName, "catA");
        Assert.assertEquals((String)"catA:A4 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"4", (Object)props.getProperty("main//confVal1"));
        props = this.writerProvider.getConfigurationProperties("B2", tagName, "catB");
        Assert.assertEquals((String)"catB:B2 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"2", (Object)props.getProperty("main//confVal2"));
        Assert.assertArrayEquals((int[])new int[]{0, 4, 2}, (int[])mainModule.getConfValues());
        s.loadConfiguration(new String[]{"D3", "catA:A1", "catB:B0"});
        Assert.assertArrayEquals((int[])new int[]{7, 1, 0}, (int[])mainModule.getConfValues());
        s.loadConfiguration(new String[0]);
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2}, (int[])mainModule.getConfValues());
        Set categories = s.getCategories();
        Assert.assertEquals((long)3L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains(""));
        Assert.assertTrue((boolean)categories.contains("catA"));
        Assert.assertTrue((boolean)categories.contains("catB"));
        s.shutdown();
    }

    @Test
    public void testErroneousConfigInput() throws Exception {
        try {
            BootUtils.getSubsystemFromFile((String)descPath, (String)"catA:,catB:wrongFile");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("wrongFile"));
        }
    }

    @Test
    public void testErroneousCategoryInput() throws Exception {
        try {
            BootUtils.getSubsystemFromFile((String)descPath, (String)"catA:,catB:,catZ:");
            Assert.fail((String)"Exception expected");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("unexisting category"));
        }
    }

    @Test
    public void testResetConfiguration() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        s.start();
        CategorizedConfigurableModule mainModule = (CategorizedConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        int[] initialValues = mainModule.getConfValues();
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.dropChangesForCategories(new String[]{"catA", "catB"});
        s.saveAllChanges();
        Assert.assertArrayEquals((int[])new int[]{10, initialValues[1], initialValues[2]}, (int[])mainModule.getConfValues());
        s.shutdown();
    }

    @Test
    public void testLoadCategories() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        s.start();
        CategorizedConfigurableModule mainModule = (CategorizedConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.saveChangesForCategoriesAs(new String[]{":D1", "catA:confA1", "catB:confB1"});
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        mainModule.change("confVal1", 7);
        s.saveChangesForCategoriesAs(new String[]{"catA:confA2"});
        Assert.assertArrayEquals((int[])new int[]{10, 7, 8}, (int[])mainModule.getConfValues());
        s.loadCategories(new String[]{"catA:confA1"});
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        s.shutdown();
    }

    @Test
    public void testSaveCategories() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        s.start();
        CategorizedConfigurableModule mainModule = (CategorizedConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.saveChangesForCategoriesAs(new String[]{"confD1", "catB:confB1"});
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        mainModule.change("confVal0", 9);
        mainModule.change("confVal2", 7);
        Assert.assertArrayEquals((int[])new int[]{9, 9, 7}, (int[])mainModule.getConfValues());
        s.saveChangesForCategories(new String[]{"", "catB"});
        Properties props = this.writerProvider.getConfigurationProperties("confD1", s.getTag(), "");
        Assert.assertEquals((String)"confD1 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal0 : ", (Object)"9", (Object)props.getProperty("main//confVal0"));
        props = this.writerProvider.getConfigurationProperties("confB1", s.getTag(), "catB");
        Assert.assertEquals((String)"catB:confB1 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal2 : ", (Object)"7", (Object)props.getProperty("main//confVal2"));
        s.saveChangesForCategoriesAs(new String[]{"catA:confA1"});
        props = this.writerProvider.getConfigurationProperties("confA1", s.getTag(), "catA");
        Assert.assertEquals((String)"catA:confA1 properties file size : ", (long)1L, (long)props.size());
        Assert.assertEquals((String)"confVal1 : ", (Object)"9", (Object)props.getProperty("main//confVal1"));
        Set configForCat = s.findAvailableConfigurationsForCategory("");
        Assert.assertEquals((long)1L, (long)configForCat.size());
        Assert.assertTrue((boolean)configForCat.contains("confD1"));
        configForCat = s.findAvailableConfigurationsForCategory("catB");
        Assert.assertEquals((long)1L, (long)configForCat.size());
        Assert.assertTrue((boolean)configForCat.contains("confB1"));
        configForCat = s.findAvailableConfigurationsForCategory("catA");
        Assert.assertEquals((long)1L, (long)configForCat.size());
        Assert.assertTrue((boolean)configForCat.contains("confA1"));
        s.shutdown();
    }

    @Test
    public void testDropCategories() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)descPath);
        s.start();
        CategorizedConfigurableModule mainModule = (CategorizedConfigurableModule)((Object)s.getLookup().getComponentByName("main"));
        int[] defaultValues = mainModule.getConfValues();
        mainModule.change("confVal0", 10);
        mainModule.change("confVal1", 9);
        mainModule.change("confVal2", 8);
        s.saveChangesForCategoriesAs(new String[]{"confD1", "catB:confB1"});
        Assert.assertArrayEquals((int[])new int[]{10, 9, 8}, (int[])mainModule.getConfValues());
        s.dropAllChanges();
        Assert.assertArrayEquals((int[])new int[]{10, defaultValues[1], 8}, (int[])mainModule.getConfValues());
        s.shutdown();
    }
}

