/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkChangeConfigurable;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationBulkChangesTest
extends CcsTestCaseTemplate {
    private static NodeModularSubsystem s;
    private static BulkChangeConfigurable withBulkSetting;

    @Before
    public void initAgents() throws Exception {
        s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationA");
        s.start();
        withBulkSetting = (BulkChangeConfigurable)((Object)s.getLookup().getComponentByName("withBulkSetting"));
    }

    @After
    public void shutdownAgents() throws Exception {
        s.shutdown();
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testBulkChange() throws Exception {
        withBulkSetting.submitChange("min", 12);
        withBulkSetting.submitChange("max", 7);
        withBulkSetting.submitChange("value", 3.75);
        try {
            s.commitBulkChange();
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertEquals((long)3L, (long)withBulkSetting.getSubmittedChanges().size());
        }
        Assert.assertEquals((long)0L, (long)withBulkSetting.getMin());
        Assert.assertEquals((long)10L, (long)withBulkSetting.getMax());
        Assert.assertEquals((double)3.14, (double)withBulkSetting.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.CONFIGURED, (Object)s.getState(ConfigurationState.class));
        withBulkSetting.submitChange("min", 7);
        withBulkSetting.submitChange("max", 12);
        withBulkSetting.submitChange("value", 3.75);
        s.commitBulkChange();
        Assert.assertEquals((long)7L, (long)withBulkSetting.getMin());
        Assert.assertEquals((long)12L, (long)withBulkSetting.getMax());
        Assert.assertEquals((double)3.75, (double)withBulkSetting.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.DIRTY, (Object)s.getState(ConfigurationState.class));
        Assert.assertEquals((long)0L, (long)withBulkSetting.getSubmittedChanges().size());
        withBulkSetting.submitChange("min", 11);
        withBulkSetting.change("max", 13);
        Assert.assertEquals((long)1L, (long)withBulkSetting.getSubmittedChanges().size());
        withBulkSetting.submitChange("max", 101);
        withBulkSetting.submitChange("value", 5.67);
        try {
            s.commitBulkChange();
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertEquals((long)0L, (long)withBulkSetting.getSubmittedChanges().size());
        }
        Assert.assertEquals((long)7L, (long)withBulkSetting.getMin());
        Assert.assertEquals((long)13L, (long)withBulkSetting.getMax());
        Assert.assertEquals((double)3.75, (double)withBulkSetting.getValue(), (double)0.0);
        Assert.assertEquals((Object)ConfigurationState.UNCONFIGURED, (Object)s.getState(ConfigurationState.class));
    }
}

