/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.node_building;

import java.io.Serializable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.annotations.ConfigChanger;

public class ModuleWithStructParms
extends Module {
    int min;
    int max;

    public ModuleWithStructParms(String name, MinMax minMax) {
        super(name);
        this.setMinMax(minMax);
    }

    final void setMin(int min) {
        if (min < 0) {
            throw new IllegalArgumentException("min should be positive");
        }
        this.min = min;
    }

    final void setMax(int max) {
        if (max > 2048) {
            throw new IllegalArgumentException("max should be less than 2048");
        }
        this.max = max;
    }

    @ConfigChanger
    public final void setMinMax(MinMax changes) {
        this.setMin(changes.min);
        this.setMax(changes.max);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ModuleWithMapParms{");
        sb.append("min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append('}');
        return sb.toString();
    }

    public static class MinMax
    implements Serializable {
        int min;
        int max;

        public MinMax(int min, int max) {
            if (min > max) {
                throw new IllegalArgumentException("max less that min");
            }
            this.min = min;
            this.max = max;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public String toString() {
            return "[" + this.min + ',' + this.max + ']';
        }
    }
}

