/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import org.lsst.ccs.HardwareException;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.TreeWalkerDiag;

public class SimpleHardwareController
extends Module
implements HardwareController {
    private final int stopLength;
    private volatile boolean isStopped = false;

    public SimpleHardwareController(String name, int stopLength) {
        super(name);
        this.stopLength = stopLength;
    }

    public TreeWalkerDiag checkHardware() throws HardwareException {
        return TreeWalkerDiag.GO;
    }

    public void checkStarted() throws HardwareException {
    }

    public void checkStopped() throws HardwareException {
        if (!this.isStopped) {
            throw new HardwareException(false, "not stopped (yet)");
        }
    }

    public TreeWalkerDiag signal(Signal sig) {
        switch (sig.getLevel()) {
            case STOP: {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(SimpleHardwareController.this.stopLength);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        SimpleHardwareController.this.isStopped = true;
                    }
                }).start();
                break;
            }
            case RE_START: {
                this.isStopped = false;
            }
        }
        return TreeWalkerDiag.GO;
    }
}

