/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.framework.Module;

public class BulkChangeConfigurable
extends Module {
    @ConfigurationParameter
    private final String otherKey;
    @ConfigurationParameter
    private String info;
    @ConfigurationParameter
    private int min;
    @ConfigurationParameter
    private int max;
    @ConfigurationParameter
    private double value;

    public BulkChangeConfigurable(String otherKey, String info, int min, int max, double value) {
        this.otherKey = otherKey;
        this.info = info;
        this.min = min;
        this.max = max;
        this.setValue(value);
    }

    public String getOtherKey() {
        return this.otherKey;
    }

    public String getInfo() {
        return this.info;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public double getValue() {
        return this.value;
    }

    @ConfigurationParameterChanger
    public void setValue(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("no negative value");
        }
        this.value = value;
    }

    @ConfigurationParameterChanger
    public void setInfo(String info) {
        this.info = info;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        if ((Integer)parametersView.get("min") > (Integer)parametersView.get("max")) {
            throw new IllegalArgumentException("min greater than max");
        }
    }

    public Map<String, Object> setBulkParameter(Map<String, Object> parametersView) {
        Object obj = parametersView.remove("max");
        if (obj != null) {
            int theMax = (Integer)obj;
            if (theMax > 100) {
                throw new IllegalArgumentException("some user exception thrown in the setBulkParameter method");
            }
            this.max = theMax;
        }
        if ((obj = parametersView.remove("min")) != null) {
            this.min = (Integer)obj;
        }
        return parametersView;
    }
}

