/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.command.proxy;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.Agent;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.layer.MessagingLayerTest;
import org.lsst.ccs.startup.BootUtils;

@RunWith(value=Parameterized.class)
public class CommandToNonConfigurableTest
extends CcsTestCaseTemplate {
    @Parameterized.Parameters(name="{0}")
    public static List<String> getTransportProtocols() {
        return MessagingLayerTest.getTransportProtocols();
    }

    public CommandToNonConfigurableTest(String transport) {
        super(transport);
    }

    @Test
    public void testSendingCommands() throws Exception {
        Agent a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.start();
        Subsystem s = BootUtils.getSubsystemFromFile((String)"subsystemDriver");
        s.start();
        s.switchToEngineeringMode();
        Thread.sleep(500L);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        Object reply = cmu.sendSynchronousCommand(new CommandRequest("SubsystemWithDriverNoProxy/aDriver", "hello"), 200L);
        Assert.assertTrue((boolean)reply.equals("Hello"));
        reply = cmu.sendSynchronousCommand(new CommandRequest("SubsystemWithDriverNoProxy/aDriver", "sayPoliteHello please"), 200L);
        Assert.assertTrue((boolean)((String)reply).startsWith("please Hello"));
        reply = cmu.sendSynchronousCommand(new CommandRequest("SubsystemWithDriverNoProxy/aDriver", "getNumber"), 200L);
        Assert.assertTrue(((Integer)reply == 2 ? 1 : 0) != 0);
        reply = cmu.sendSynchronousCommand(new CommandRequest("SubsystemWithDriverNoProxy/aDriver", "addNumbers 10 4 67"), 200L);
        Assert.assertTrue(((Integer)reply == 81 ? 1 : 0) != 0);
        reply = cmu.sendSynchronousCommand(new CommandRequest("SubsystemWithDriverNoProxy/aDriver", "addNumbers", new Object[]{new int[]{3, 4, 55}}), 200L);
        Assert.assertTrue(((Integer)reply == 62 ? 1 : 0) != 0);
        reply = cmu.sendSynchronousCommand(new CommandRequest("SubsystemWithDriverNoProxy/aDriver", "addNumbers", new Object[]{new int[0]}), 200L);
        Assert.assertTrue(((Integer)reply == 0 ? 1 : 0) != 0);
        s.shutdown();
        a.shutdown();
    }
}

