/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.SimpleConfigurableAnnotated;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;

public class ConfigurableParametersPickingTest
extends CcsTestCaseTemplate {
    @Test
    public void testExtractParameters() throws Exception {
        SubsystemDescription subDesc = BootUtils.buildSubsystemDescription((String)"configurationC");
        Map parmDescs = subDesc.getParamDescriptionMap();
        Assert.assertEquals((long)16L, (long)parmDescs.size());
    }

    @Test
    public void testBuildEffectiveNode() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"configurationC");
        EffectiveNode effectiveNode = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        SimpleConfigurableAnnotated c = (SimpleConfigurableAnnotated)((Object)effectiveNode.getIndirect((Object)"annotatedSon"));
        Assert.assertEquals((double)3.14, (double)c.getDoubleVal(), (double)0.01);
        int[] intArray = c.getIntArray();
        Assert.assertEquals((long)4L, (long)intArray.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        Map<String, Integer> map = c.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.get("first").intValue());
        Assert.assertEquals((long)2L, (long)map.get("second").intValue());
        Assert.assertEquals((long)3L, (long)map.get("third").intValue());
    }
}

