/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup.remote;

import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.config.remote.ProfileResult;
import org.lsst.ccs.config.remote.scripts.ConfigurationBusClient;
import org.lsst.ccs.config.remote.scripts.RegisterConfigurationFromFile;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.startup.remote.RegisterDescriptionFromFile;
import org.lsst.ccs.utilities.jars.CommonResources;

public class FireConfigRegistration {
    public static void main(String[] args) throws Exception {
        ConfigurationBusClient busClient = new ConfigurationBusClient();
        if (args.length == 0) {
            FireConfigRegistration.usage();
            return;
        }
        String todo = args[0];
        if ("descr:".equals(todo)) {
            FireConfigRegistration.registerPureDescription(args);
        } else if ("descr+conf:".equals(todo)) {
            FireConfigRegistration.registerDescAndConf(args);
        } else if ("conf:".equals(todo)) {
            FireConfigRegistration.registerConfiguration(args);
        } else {
            FireConfigRegistration.usage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerPureDescription(String[] args) throws Exception {
        String fileName = args[1];
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath((String)fileName);
        String subsystemName = namesAndTag.getSubsystemName();
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        if (!"".equals(configName) || !"".equals(tag)) {
            throw new IllegalArgumentException(fileName + " does not represent a core description");
        }
        try (ConfigurationBusClient busClient = new ConfigurationBusClient();){
            RegisterDescriptionFromFile descriptionRegister = new RegisterDescriptionFromFile(busClient);
            DescriptionResult descriptionResult = descriptionRegister.register(fileName);
            SubsystemDescription subsystemDescription = descriptionResult.getResult();
            System.out.println(subsystemDescription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDescAndConf(String[] args) throws Exception {
        String fileName = args[1];
        String categoryName = args[2];
        String configName = args[3];
        try (ConfigurationBusClient client = new ConfigurationBusClient();){
            RegisterDescriptionFromFile descriptionRegister = new RegisterDescriptionFromFile(client);
            RegisterConfigurationFromFile configRegister = new RegisterConfigurationFromFile(client);
            DescriptionResult descriptionResult = descriptionRegister.register(fileName);
            SubsystemDescription subsystemDescription = descriptionResult.getResult();
            ProfileResult profileResult = configRegister.register(subsystemDescription, categoryName, configName, "", 10);
            System.out.println(profileResult.getResult());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerConfiguration(String[] args) throws Exception {
        String realSubsystemName = args[1];
        String propsFileName = args[2];
        try (ConfigurationBusClient client = new ConfigurationBusClient();){
            NamesAndTag namesAndTag = ConfigUtils.namesFromPath((String)propsFileName);
            String subsystemName = namesAndTag.getSubsystemName();
            if (!subsystemName.equals(realSubsystemName)) {
                throw new IllegalArgumentException(subsystemName + "not coherent with " + realSubsystemName);
            }
            String configName = namesAndTag.getConfigName();
            String tag = namesAndTag.getTag();
            InputStream is = CommonResources.getInput(FireConfigRegistration.class, (String)propsFileName);
            Properties properties = new Properties();
            properties.load(is);
            Object res = client.invoke("registerConfiguration", new Object[]{subsystemName, configName, tag, "", 10, properties});
            System.out.println(res);
        }
    }

    public static void usage() {
        System.err.println("usage :\n\tdescr: pureDescriptionFileName\n\tdescr+conf: pureDescriptionFileName confFileName\n\tconf: descriptionName confFileName\n\tmach:  descriptionName configName tagName");
    }
}

