package org.lsst.ccs.startup;

import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

/**
 * @author bamade
 */
// Date: 11/10/12

public class SubsystemBoot {
    static String descriptionName ;
    static String configurationFileName ;
    static String subsystemAlias = null;

    public static void main(String[] args) throws Exception {

        parseArgsCLI(args);

        if(descriptionName == null ) {
            throw  new  IllegalArgumentException("no description specification") ;
        } else {

            if(configurationFileName != null) {
                SubsystemBootFromStream.main(new String[] {subsystemAlias, descriptionName, configurationFileName});
            } else {
                SubsystemBootFromStream.main(new String[] {subsystemAlias, descriptionName});
            }
//            } else { 


                
// from bus                
//               if(configurationFileName != null) {
//                   if(configurationFileName.contains(".")) {
//                        throw new UnsupportedOperationException(
//                               "loading description from bus and configuration locally"
//                       ) ;
//                    } else { // tautological
//                        //split configuration name into config_tag
//                       String[] names = configurationFileName.split("_") ;
//                       switch(names.length) {
//                           case 1 :
//                               SubsystemBootFromBus.main(new String[] {descriptionName, configurationFileName});
//                               break ;
//                           case 2 :
//                               SubsystemBootFromBus.main(new String[] {descriptionName, names[0], names[1]});
//                               break ;
//                           default :
//                                throw new IllegalArgumentException(
//                                       "too many underscores in " +configurationFileName
//                               ) ;
//                        }
//                    }
//                } else {
//                   SubsystemBootFromBus.main(new String[] {descriptionName});
//
//                }
//            }

        }

    }

    static void parseArgsCLI(String[] args) {
        // define the command line options
        Options commandLineOptions = new Options();
        // The help option
        commandLineOptions.addOption("h", "help", false, "Print the help message");
        // The verbose option
        commandLineOptions.addOption("v", "verbose", false, "Turns on verbose statements");
        // The name of the description file.
        commandLineOptions.addOption("d", "description", true,
                "Name of Subsystem description file.");
        commandLineOptions.getOption("description").setArgName("DESCRIPTION_FILE");
        // The name of the configuration properties file.
        commandLineOptions.addOption("c", "configuration", true,
                "Name of Configuration properties file.");
        commandLineOptions.getOption("configuration").setArgName("CONFIGURATION_FILE");
        commandLineOptions.addOption("a","alias", true, "Name of subsystem on the buses.");
        commandLineOptions.getOption("alias").setArgName("SUBSYSTEM_NAME");

        CommandLineParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(commandLineOptions, args, false);
            
            if (line.hasOption("help")) {
                usageCLI(commandLineOptions);
            } else {
                descriptionName = line.getOptionValue("description");
                configurationFileName = line.getOptionValue("configuration");
                subsystemAlias = line.getOptionValue("alias");
            }

        } catch (Exception e) {
            usageCLI(commandLineOptions);
        }

    }

    static void usageCLI(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "SubsystemBoot", "", options, "", true);
        System.exit(0);
    }

}
