/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.framework;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.lsst.ccs.Agent;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.command.BasicCommand;
import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.TokenizedCommand;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.SimpleModule;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.messaging.layer.MessagingLayerTest;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.ccs.utilities.structs.TreeBranch;

@RunWith(value=Parameterized.class)
public class SimpleModuleTest
extends CcsTestCaseTemplate {
    private final String signalLevel = SignalLevel.INTERRUPT1.toString();

    @Parameterized.Parameters(name="{0}")
    public static List<String> getTransportProtocols() {
        return MessagingLayerTest.getTransportProtocols();
    }

    public SimpleModuleTest(String transport) {
        super(transport);
    }

    @Test
    public void testModularSubsystem() throws Exception {
        Agent a = new Agent("console", AgentInfo.AgentType.CONSOLE);
        a.start();
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"simpleModuleWithConfigurableComponent");
        s.start();
        s.switchToEngineeringMode();
        Thread.sleep(500L);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(a.getMessagingAccess());
        SimpleModule main = (SimpleModule)((Object)s.getLookup().getComponentByName("main"));
        SimpleModule child = (SimpleModule)((Object)s.getLookup().getComponentByName("childModule"));
        Configurable configurable = (Configurable)s.getLookup().getComponentByName("childConfigurable");
        Assert.assertNotNull((Object)((Object)main));
        Assert.assertNotNull((Object)((Object)child));
        Assert.assertNotNull((Object)configurable);
        Assert.assertTrue((boolean)main.isInitPerformed());
        cmu.sendSynchronousCommand(new CommandRequest("simpleModuleTest", "sendSignal", new Object[]{this.signalLevel}), 100L);
        Assert.assertEquals((Object)this.signalLevel, (Object)main.lastSignal.getLevel().name());
        Assert.assertEquals((Object)this.signalLevel, (Object)child.lastSignal.getLevel().name());
        HashMap dictMap = (HashMap)cmu.sendSynchronousCommand(new CommandRequest("simpleModuleTest", "getDictionaries"), 100L);
        Dictionary dictionary = (Dictionary)dictMap.get(s.getName());
        Assert.assertTrue((boolean)dictionary.containsCommand((BasicCommand)new TokenizedCommand("clearAlerts alert23 alert1")));
        TreeBranch tree = (TreeBranch)cmu.sendSynchronousCommand(new CommandRequest("simpleModuleTest", "getComponentTree"), 100L);
        Assert.assertEquals((Object)"main", (Object)tree.getContent());
        Assert.assertNull((Object)tree.getParent());
        List children = tree.getChildren();
        Assert.assertEquals((Object)"childModule", (Object)((TreeBranch)children.get(0)).getContent());
        cmu.sendSynchronousCommand(new CommandRequest("simpleModuleTest/childModule/subModule", "sendSignal", new Object[]{this.signalLevel}), 100L);
        cmu.sendSynchronousCommand(new CommandRequest("simpleModuleTest/subModule", "sendSignal", new Object[]{this.signalLevel}), 100L);
        main.setTickMillis(100);
        main.setTicks(0);
        Thread.sleep(400L);
        Assert.assertTrue((main.getTicks() > 0 ? 1 : 0) != 0);
        main.setTickMillis(-1);
        Thread.sleep(400L);
        main.setTicks(0);
        Thread.sleep(400L);
        Assert.assertEquals((long)0L, (long)main.getTicks());
        s.shutdown();
        a.shutdown();
    }
}

