/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.SimpleConfigurableAnnotated;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.node_building.ModuleWithMapParms;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class NodeBuildingTest
extends CcsTestCaseTemplate {
    private static final String simpleParmsAPath = "simpleParmsA";
    private static final String mapParmsAPath = "mapParmsA";
    private LocalConfigurationProxy.WriterProvider writerProvider;

    @Before
    public void initTest() {
        this.writerProvider = LocalConfigurationProxy.getWriterProvider();
    }

    @After
    public void tearDown() {
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)simpleParmsAPath);
        Module mainModule = (Module)s.getLookup().getComponentByName("main");
        LinkedHashMap modules = mainModule.getChildren(Module.class);
        for (Map.Entry entry : modules.entrySet()) {
            Module m = (Module)entry.getValue();
            Assert.assertEquals((String)("main module and " + m + " child should be equal"), (Object)mainModule, (Object)m);
        }
        Configurable topConfigurable = (Configurable)s.getLookup().getComponentByName("cfTop");
        LinkedHashMap configurables = topConfigurable.getChildren(Configurable.class);
        for (Map.Entry entry : configurables.entrySet()) {
            Configurable c = (Configurable)entry.getValue();
            Assert.assertEquals((String)("top configurable and " + c + " child should be equal"), (Object)topConfigurable, (Object)c);
        }
    }

    @Test
    public void testMapParmsDirectBuild() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)mapParmsAPath);
        ModuleWithMapParms mainModule = (ModuleWithMapParms)((Object)s.getLookup().getComponentByName("main"));
        Assert.assertNotEquals((String)("min should be set " + mainModule.getMin()), (long)0L, (long)mainModule.getMin());
        Assert.assertNotEquals((String)("max should be set " + mainModule.getMax()), (long)0L, (long)mainModule.getMax());
    }

    @Test
    public void testMapParmsPropsOKDirect() throws Exception {
        String configOK = "testMapParmsPropsOK";
        PrintWriter printWriter = this.writerProvider.getPrintWriter(configOK, mapParmsAPath, "");
        printWriter.println("main//minMax=[min:11,max:99]");
        printWriter.println("mapChild//minMax=[min:11,max:99]");
        printWriter.flush();
        printWriter.close();
        BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)configOK);
    }

    @Test
    public void testMapParmsPropsFailDirect() throws Exception {
        String configFail = "testMapParmsPropsFail";
        PrintWriter printWriter = this.writerProvider.getPrintWriter(configFail, simpleParmsAPath, "");
        printWriter.println("main//anInt=207");
        printWriter.flush();
        printWriter.close();
        try {
            BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)configFail);
            Assert.fail((String)"configuration loading should fail");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)(ex instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testBuildEffectiveNodeFromConfigurationData() throws Exception {
        String configName = "testBuildFromExistingConfig";
        PrintWriter printWriter = this.writerProvider.getPrintWriter(configName, "configurationC", "");
        LocalConfigurationProxy.setWriterProvider((LocalConfigurationProxy.WriterProvider)this.writerProvider);
        printWriter.println("son//confVal0=1");
        printWriter.println("son//confVal1=1");
        printWriter.println("son//confVal2=1");
        printWriter.println("annotatedSon//annotatedDouble=6.28");
        printWriter.println("annotatedSon//annotatedIntArray=[2,4,6,8]");
        printWriter.println("annotatedSon//annotatedMap=[first:2, second:4, third:6]");
        printWriter.println("annotatedSon//annotatedString=" + configName);
        printWriter.println("otherAnnotatedSon//annotatedDouble=6.28");
        printWriter.println("otherAnnotatedSon//annotatedIntArray=[2,4,6,8]");
        printWriter.println("otherAnnotatedSon//annotatedMap=[first:2, second:4, third:6]");
        printWriter.println("otherAnnotatedSon//annotatedString=" + configName);
        printWriter.flush();
        printWriter.close();
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationC", (String)configName);
        s.start();
        SimpleConfigurableAnnotated annotatedSon = (SimpleConfigurableAnnotated)((Object)s.getLookup().getComponentByName("annotatedSon"));
        SimpleConfigurableAnnotated otherAnnotatedSon = (SimpleConfigurableAnnotated)((Object)s.getLookup().getComponentByName("otherAnnotatedSon"));
        Assert.assertEquals((double)6.28, (double)annotatedSon.getDoubleVal(), (double)0.01);
        int[] intArray = annotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{2, 4, 6, 8}, (int[])intArray);
        Map<String, Integer> map = annotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)2L, (long)map.get("first").intValue());
        Assert.assertEquals((long)4L, (long)map.get("second").intValue());
        Assert.assertEquals((long)6L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)configName, (Object)annotatedSon.getString());
        Assert.assertEquals((double)6.28, (double)otherAnnotatedSon.getDoubleVal(), (double)0.01);
        intArray = otherAnnotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{2, 4, 6, 8}, (int[])intArray);
        map = otherAnnotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)2L, (long)map.get("first").intValue());
        Assert.assertEquals((long)4L, (long)map.get("second").intValue());
        Assert.assertEquals((long)6L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)configName, (Object)otherAnnotatedSon.getString());
        s.loadConfiguration(new String[0]);
        Assert.assertEquals((double)3.14, (double)annotatedSon.getDoubleVal(), (double)0.01);
        intArray = annotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        map = annotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.get("first").intValue());
        Assert.assertEquals((long)2L, (long)map.get("second").intValue());
        Assert.assertEquals((long)3L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)"initialValue", (Object)annotatedSon.getString());
        Assert.assertEquals((double)3.14, (double)otherAnnotatedSon.getDoubleVal(), (double)0.01);
        intArray = otherAnnotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        map = otherAnnotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.get("first").intValue());
        Assert.assertEquals((long)2L, (long)map.get("second").intValue());
        Assert.assertEquals((long)3L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)"initialValue", (Object)otherAnnotatedSon.getString());
        s.shutdown();
    }
}

