/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.config.ConfigureMe;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.framework.BulkSettingException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurationATest
extends CcsTestCaseTemplate {
    private static final double doubleVal = 7.65;
    private static final double newVal = 10.0;
    private static NodeModularSubsystem s;
    private static ConfigureMe mainModule;
    private static ConfigureMe childModule;
    private LocalConfigurationProxy.WriterProvider writerProvider;

    @Before
    public void initAgents() throws Exception {
        this.writerProvider = LocalConfigurationProxy.getWriterProvider();
        s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationA");
        s.start();
        childModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("son"));
        mainModule = (ConfigureMe)((Object)s.getLookup().getComponentByName("main"));
    }

    @After
    public void shutdownAgents() throws Exception {
        s.shutdown();
        LocalConfigurationProxy.setWriterProvider(null);
    }

    @Test
    public void testStaticParameterModification() throws Exception {
        boolean operationlState = s.waitFor(state -> state.isInState((Enum)PhaseState.OPERATIONAL), 10L, TimeUnit.SECONDS);
        Assert.assertTrue((boolean)operationlState);
        try {
            mainModule.change("info", "newValue");
            Assert.fail();
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("not modifiable at runtime"));
        }
        childModule.change("info", "newValue");
        Assert.assertEquals((String)"child value : ", (Object)"newValue", (Object)childModule.getInfo());
    }

    @Test
    public void testConstraintRangeCheck() throws Exception {
        try {
            childModule.change("max", 4000);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("not in range"));
        }
    }

    @Test
    public void testParameterNotConfigChanger() throws Exception {
        try {
            childModule.change("otherInt", 1000);
            Assert.fail();
        }
        catch (BulkSettingException ex) {
            Assert.assertTrue((String)ex.getMessage(), (boolean)ex.getMessage().contains("otherInt"));
        }
    }

    @Test
    public void testUserDefinedConfigMethod() {
        try {
            childModule.submitChange("min", -1);
            childModule.submitChange("max", 0);
            s.commitBulkChange();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            childModule.submitChange("min", 0);
            childModule.submitChange("max", 5000);
            s.commitBulkChange();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        childModule.submitChange("min", 20);
        childModule.submitChange("max", 1500);
        s.commitBulkChange();
        Assert.assertEquals((String)"min : ", (long)20L, (long)childModule.getMin());
        Assert.assertEquals((String)"max : ", (long)1500L, (long)childModule.getMax());
    }

    @Test
    public void testSaveConfigurationA() throws Exception {
        childModule.change("value", 7.65);
        childModule.change("info", "newValue");
        childModule.change("value", 10.0);
        childModule.submitChange("min", 20);
        childModule.submitChange("max", 1500);
        s.commitBulkChange();
        s.saveChangesForCategoriesAs(new String[]{"configurationA"});
        Properties properties = this.writerProvider.getConfigurationProperties("configurationA", s.getTag(), "");
        String propValue = properties.getProperty("son//value");
        String maxValue = properties.getProperty("son//max");
        Assert.assertEquals((String)"son//value : ", (double)10.0, (double)Double.parseDouble(propValue), (double)0.0);
        Assert.assertEquals((String)"son//max : ", (long)1500L, (long)Integer.parseInt(maxValue));
        Assert.assertEquals((String)("modification size : " + properties.toString()), (long)4L, (long)properties.size());
    }
}

