package org.lsst.ccs.startup.remote;

import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.config.utilities.ConfigUtils;
import java.io.Serializable;
import org.lsst.ccs.config.remote.scripts.ConfigurationBusClient;
import org.lsst.ccs.description.ComponentNodeBuilder;

/**
 * gets description data from a file and registers it to the remote configuration service (on top of command bus).
 * @author bamade
 */
// Date: 19/07/12

    //TODO: fix modularity problems with dependencies to startup package

public class RegisterDescriptionFromFile {
    ConfigurationBusClient busClient  ;

    public RegisterDescriptionFromFile(ConfigurationBusClient busClient) {
        this.busClient = busClient;
    }

    public DescriptionResult register(String pathName) throws Exception {
        //todo: code duplication from SubsystemBootfromStream -> move to utility code
        Serializable componentNode = null ;
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath(pathName) ;
        //split name
        String subsystemName = namesAndTag.getSubsystemName() ;
        String configName = namesAndTag.getConfigName() ;
        String tag = namesAndTag.getTag() ;
        
        componentNode = ComponentNodeBuilder.buildDescriptiveNode(pathName);
        
        SubsystemDescription description = Factories.createRawSubsystemDescription(subsystemName, tag,
                componentNode);
        // creates a SubsystemDescription
        Object res = busClient.invoke("registerSubsystemDescription", description) ;

        // remotely registers it and returns the result
        return (DescriptionResult) res ;
    }
}
