/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.PrintWriter;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.SimpleConfigurableAnnotated;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurableParametersPickingTest
extends CcsTestCaseTemplate {
    @Test
    public void testExtractParameters() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"configurationC");
        SubsystemDescription subDesc = BootUtils.buildSubsystemDescription((String)"", (String)"", (DescriptiveNode)descriptiveNode);
        Map parmDescs = subDesc.getParamDescriptionMap();
        Assert.assertEquals((long)16L, (long)parmDescs.size());
    }

    @Test
    public void testBuildEffectiveNode() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"configurationC");
        EffectiveNode effectiveNode = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        SimpleConfigurableAnnotated c = (SimpleConfigurableAnnotated)((Object)effectiveNode.getIndirect((Object)"annotatedSon"));
        Assert.assertEquals((double)3.14, (double)c.getDoubleVal(), (double)0.01);
        int[] intArray = c.getIntArray();
        Assert.assertEquals((long)4L, (long)intArray.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        Map<String, Integer> map = c.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((1 == map.get("first") ? 1 : 0) != 0);
        Assert.assertTrue((2 == map.get("second") ? 1 : 0) != 0);
        Assert.assertTrue((3 == map.get("third") ? 1 : 0) != 0);
    }

    @Test
    public void testBuildEffectiveNodeFromConfigurationData() throws Exception {
        PrintWriter printWriter = InMemoryWriterProvider.newInstance().getPrintWriter("config1", "configurationC", "");
        printWriter.println("son//confVal0=1");
        printWriter.println("son//confVal1=1");
        printWriter.println("son//confVal2=1");
        printWriter.println("annotatedSon//annotatedDouble=6.28");
        printWriter.println("annotatedSon//annotatedIntArray=[2,4,6,8]");
        printWriter.println("annotatedSon//annotatedMap=[first:2, second:4, third:6]");
        printWriter.println("annotatedSon//annotatedString=config1");
        printWriter.println("otherAnnotatedSon//annotatedDouble=6.28");
        printWriter.println("otherAnnotatedSon//annotatedIntArray=[2,4,6,8]");
        printWriter.println("otherAnnotatedSon//annotatedMap=[first:2, second:4, third:6]");
        printWriter.println("otherAnnotatedSon//annotatedString=config1");
        printWriter.flush();
        printWriter.close();
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationC", (String)"config1");
        s.start();
        SimpleConfigurableAnnotated annotatedSon = (SimpleConfigurableAnnotated)((Object)s.getLookup().getComponentByName("annotatedSon"));
        SimpleConfigurableAnnotated otherAnnotatedSon = (SimpleConfigurableAnnotated)((Object)s.getLookup().getComponentByName("otherAnnotatedSon"));
        Assert.assertEquals((double)6.28, (double)annotatedSon.getDoubleVal(), (double)0.01);
        int[] intArray = annotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{2, 4, 6, 8}, (int[])intArray);
        Map<String, Integer> map = annotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)2L, (long)map.get("first").intValue());
        Assert.assertEquals((long)4L, (long)map.get("second").intValue());
        Assert.assertEquals((long)6L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)"config1", (Object)annotatedSon.getString());
        Assert.assertEquals((double)6.28, (double)otherAnnotatedSon.getDoubleVal(), (double)0.01);
        intArray = otherAnnotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{2, 4, 6, 8}, (int[])intArray);
        map = otherAnnotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)2L, (long)map.get("first").intValue());
        Assert.assertEquals((long)4L, (long)map.get("second").intValue());
        Assert.assertEquals((long)6L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)"config1", (Object)otherAnnotatedSon.getString());
        s.loadConfiguration(new String[0]);
        Assert.assertEquals((double)3.14, (double)annotatedSon.getDoubleVal(), (double)0.01);
        intArray = annotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        map = annotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.get("first").intValue());
        Assert.assertEquals((long)2L, (long)map.get("second").intValue());
        Assert.assertEquals((long)3L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)"initialValue", (Object)annotatedSon.getString());
        Assert.assertEquals((double)3.14, (double)otherAnnotatedSon.getDoubleVal(), (double)0.01);
        intArray = otherAnnotatedSon.getIntArray();
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        map = otherAnnotatedSon.getMap();
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertEquals((long)1L, (long)map.get("first").intValue());
        Assert.assertEquals((long)2L, (long)map.get("second").intValue());
        Assert.assertEquals((long)3L, (long)map.get("third").intValue());
        Assert.assertEquals((Object)"initialValue", (Object)otherAnnotatedSon.getString());
        s.shutdown();
    }
}

