/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.node_building;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.node_building.ModuleWithMapParms;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class NodeBuildingTest
extends CcsTestCaseTemplate {
    private static final String simpleParmsAPath = "simpleParmsA";
    private static final String mapParmsAPath = "mapParmsA";

    @Before
    public void initTest() {
        InMemoryWriterProvider.newInstance();
    }

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)simpleParmsAPath);
        Module mainModule = (Module)s.getLookup().getComponentByName("main");
        LinkedHashMap modules = mainModule.getChildren(Module.class);
        for (Map.Entry entry : modules.entrySet()) {
            Module m = (Module)entry.getValue();
            Assert.assertEquals((String)("main module and " + m + " child should be equal"), (Object)mainModule, (Object)m);
        }
        Configurable topConfigurable = (Configurable)s.getLookup().getComponentByName("cfTop");
        LinkedHashMap configurables = topConfigurable.getChildren(Configurable.class);
        for (Map.Entry entry : configurables.entrySet()) {
            Configurable c = (Configurable)entry.getValue();
            Assert.assertEquals((String)("top configurable and " + c + " child should be equal"), (Object)topConfigurable, (Object)c);
        }
    }

    @Test
    public void testMapParmsDirectBuild() throws Exception {
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)mapParmsAPath);
        ModuleWithMapParms mainModule = (ModuleWithMapParms)((Object)s.getLookup().getComponentByName("main"));
        Assert.assertNotEquals((String)("min should be set " + mainModule.min), (long)0L, (long)mainModule.min);
        Assert.assertNotEquals((String)("max should be set " + mainModule.max), (long)0L, (long)mainModule.max);
    }

    @Test
    public void testMapParmsPropsOKDirect() throws Exception {
        PrintWriter printWriter = InMemoryWriterProvider.getInstance().getPrintWriter("ok", mapParmsAPath, "");
        printWriter.println("main//minMax=[min:11,max:99]");
        printWriter.println("mapChild//minMax=[min:11,max:99]");
        printWriter.flush();
        printWriter.close();
        BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)"ok");
    }

    @Test
    public void testMapParmsPropsFailDirect() throws Exception {
        PrintWriter printWriter = InMemoryWriterProvider.getInstance().getPrintWriter("fail", simpleParmsAPath, "");
        printWriter.println("main//anInt=207");
        printWriter.flush();
        printWriter.close();
        try {
            BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)"fail");
            Assert.fail((String)"configuration loading should fail");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)(ex instanceof IllegalArgumentException));
        }
    }
}

