/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.PrintWriter;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.SimpleConfigurableAnnotated;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigurableParametersPickingTest {
    @Test
    public void testExtractParameters() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"configurationC");
        SubsystemDescription subDesc = BootUtils.buildSubsystemDescription((String)"", (String)"", (DescriptiveNode)descriptiveNode);
        Map parmDescs = subDesc.getParamDescriptionMap();
        Assert.assertEquals((long)14L, (long)parmDescs.size());
    }

    @Test
    public void testBuildEffectiveNode() throws Exception {
        DescriptiveNode descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)"configurationC");
        EffectiveNode effectiveNode = ComponentNodeBuilder.buildEffectiveNode((DescriptiveNode)descriptiveNode);
        SimpleConfigurableAnnotated c = (SimpleConfigurableAnnotated)((Object)effectiveNode.getIndirect((Object)"annotatedSon"));
        Assert.assertEquals((double)3.14, (double)c.getDoubleVal(true), (double)0.01);
        int[] intArray = c.getIntArray(true);
        Assert.assertEquals((long)4L, (long)intArray.length);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3, 4}, (int[])intArray);
        Map<String, Integer> map = c.getMap(true);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((1 == map.get("first") ? 1 : 0) != 0);
        Assert.assertTrue((2 == map.get("second") ? 1 : 0) != 0);
        Assert.assertTrue((3 == map.get("third") ? 1 : 0) != 0);
    }

    @Test
    public void testBuildEffectiveNodeFromConfigurationData() throws Exception {
        PrintWriter printWriter = InMemoryWriterProvider.newInstance().getPrintWriter("", "configurationC", "");
        printWriter.println("annotatedSon//annotatedDouble=6.28");
        printWriter.println("annotatedSon//annotatedIntArray=[2,4,6,8]");
        printWriter.println("annotatedSon//annotatedMap=[first:2, second:4, third:6]");
        printWriter.flush();
        printWriter.close();
        NodeModularSubsystem s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationC");
        SimpleConfigurableAnnotated c = (SimpleConfigurableAnnotated)((Object)s.getLookup().getComponentByName("annotatedSon"));
        Assert.assertEquals((double)6.28, (double)c.getDoubleVal(true), (double)0.01);
        int[] intArray = c.getIntArray(true);
        Assert.assertEquals((long)4L, (long)intArray.length);
        Assert.assertArrayEquals((int[])new int[]{2, 4, 6, 8}, (int[])intArray);
        Map<String, Integer> map = c.getMap(true);
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((2 == map.get("first") ? 1 : 0) != 0);
        Assert.assertTrue((4 == map.get("second") ? 1 : 0) != 0);
        Assert.assertTrue((6 == map.get("third") ? 1 : 0) != 0);
    }
}

