/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config.database;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurationFacade;
import org.lsst.ccs.config.DBInterface;
import org.lsst.ccs.config.DeprecationListener;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.dao.hibernate.HibernateDAO;
import org.lsst.ccs.config.database.TztDeprecationListener;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class ConfigDatabaseTest
extends CcsTestCaseTemplate {
    private static ConfigurationFacade.Profiles profilesA;
    private static ConfigurationFacade.Profiles profilesB;
    private static DescriptiveNode topNodeA;
    private static DescriptiveNode topNodeB;
    private static ConfigurationFacade configurationFacade;

    @BeforeClass
    public static void setupClass() throws Exception {
        System.setProperty("hsqldb.reconfig_logging", "true");
        System.setProperty("org.jboss.logging.provider", "jdk");
        Logger.getLogger("hsqldb.db").setLevel(Level.OFF);
        Logger.getLogger("org.hibernate").setLevel(Level.OFF);
        Logger.getLogger("org.jboss").setLevel(Level.OFF);
        HibernateDAO hibernateDAO = new HibernateDAO(new File("src/test/resources/hsql_mem_hibernate.cfg.xml"));
        configurationFacade = new ConfigurationFacade((DBInterface)hibernateDAO);
        profilesA = new ConfigurationFacade.Profiles();
        profilesB = new ConfigurationFacade.Profiles();
        TztDeprecationListener deprecationListener = new TztDeprecationListener();
        configurationFacade.setDeprecationListener((DeprecationListener)deprecationListener);
        topNodeA = ComponentNodeBuilder.buildDescriptiveNode((String)"configurationA");
        topNodeB = ComponentNodeBuilder.buildDescriptiveNode((String)"mapParmsA");
    }

    @Before
    public void init() {
        InMemoryWriterProvider.newInstance();
    }

    @Test
    public void testScenarios() throws Exception {
        SubsystemDescription subsystemDescriptionA = BootUtils.buildSubsystemDescription((String)"configurationA", (String)"tagA", (DescriptiveNode)topNodeA);
        Assert.assertNotNull((Object)subsystemDescriptionA);
        SubsystemDescription subsystemDescriptionB = BootUtils.buildSubsystemDescription((String)"configurationB", (String)"tagA", (DescriptiveNode)topNodeA);
        Assert.assertNotNull((Object)subsystemDescriptionB);
        configurationFacade.registerSubsystemDescription(subsystemDescriptionA, profilesA);
        ConfigProfile defaultProfileA = (ConfigProfile)profilesA.getRegistered().get(0);
        System.out.println("registered subsystem description " + subsystemDescriptionA);
        System.out.println("registered default configuration" + defaultProfileA);
        long idA = subsystemDescriptionA.getId();
        Assert.assertTrue((String)"id of subsystem description should be > 0", (idA > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)("default profile problem ? " + defaultProfileA), (Object)defaultProfileA);
        Assert.assertEquals((String)("default profile problem ? " + defaultProfileA), (Object)":", (Object)defaultProfileA.getName());
        configurationFacade.registerSubsystemDescription(subsystemDescriptionB, profilesB);
        ConfigProfile defaultProfileB = (ConfigProfile)profilesB.getRegistered().get(0);
        System.out.println("registered subsystem description " + subsystemDescriptionB);
        System.out.println("registered default configuration" + defaultProfileB);
        Assert.assertTrue((String)"id of subsystem description should be > 0", (subsystemDescriptionB.getId() > 0L ? 1 : 0) != 0);
        Assert.assertNotNull((String)("default profile problem ? " + defaultProfileB), (Object)defaultProfileB);
        Assert.assertEquals((String)("default profile problem ? " + defaultProfileB), (Object)":", (Object)defaultProfileB.getName());
        configurationFacade.registerSubsystemDescription(subsystemDescriptionA, profilesA.clear());
        Assert.assertEquals((String)"same registration should not change object", (long)idA, (long)subsystemDescriptionA.getId());
        List l = configurationFacade.simpleHQLRequest("from AConfigProfile");
        Assert.assertEquals((String)("there should be 2 different default profiles :" + l), (long)2L, (long)l.size());
        ConfigProfile configProfileA1 = Factories.createRawConfigProfile((SubsystemDescription)subsystemDescriptionA, (String)"", (String)"config1");
        Assert.assertNotNull((String)"initial profile should not be null", (Object)configProfileA1);
        ConfigProfile staticConfigProfile = Factories.copyProfile((ConfigProfile)defaultProfileA, (String)"config2", (boolean)false);
        Assert.assertNotNull((String)"initial profile should not be null", (Object)staticConfigProfile);
        ConfigProfile failConfigProfile = Factories.copyProfile((ConfigProfile)defaultProfileA, (String)"config3", (boolean)false);
        Assert.assertNotNull((String)"initial profile should not be null", (Object)failConfigProfile);
        configProfileA1.addParameterConfiguration("main//max", "2000");
        staticConfigProfile.addParameterConfiguration("main//max", "2000");
        failConfigProfile.addParameterConfiguration("main//max", "2000");
        staticConfigProfile.addParameterConfiguration("main//info", "static!");
        staticConfigProfile.addParameterConfiguration("main//max", "10");
        failConfigProfile.addParameterConfiguration("main//value", "-2000.0");
        BootUtils.checkStaticCompatibleConfiguration((ConfigProfile)configProfileA1);
        BootUtils.checkStaticCompatibleConfiguration((ConfigProfile)staticConfigProfile);
        try {
            BootUtils.checkStaticCompatibleConfiguration((ConfigProfile)failConfigProfile);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("Registering configProfileA");
        configurationFacade.registerConfigProfile(configProfileA1);
        Assert.assertTrue((String)"id of profile should be >0", (configProfileA1.getId() > 0L ? 1 : 0) != 0);
        System.out.println("Registering configProfileB");
        configurationFacade.registerConfigProfile(staticConfigProfile);
        Assert.assertTrue((String)"id of profile should be >0", (staticConfigProfile.getId() > 0L ? 1 : 0) != 0);
        Thread.sleep(200L);
        long start1 = System.currentTimeMillis();
        long end1 = start1 + 2000L;
        long middle1 = (start1 + end1) / 2L;
        System.out.println("Registering run for configurationA");
        configurationFacade.registerRun("configurationA", ":config1", "tagA", start1);
        SubsystemDescription description = configurationFacade.getActiveSubsystemDescription("configurationA", "tagA");
        System.out.println("DESCRIPTION QUERY YIELDS " + description);
        Assert.assertNotEquals((String)"size of parameter description should be >0", (long)0L, (long)description.getParamDescriptionMap().size());
        ConfigProfile runningConfig = configurationFacade.getConfigRunningAt("configurationA", middle1);
        Assert.assertNotNull((Object)runningConfig);
        Assert.assertEquals((Object)":config1", (Object)runningConfig.getName());
        String value = configurationFacade.getActiveValueAt("configurationA", "main//info", middle1);
        Assert.assertEquals((Object)"testMain", (Object)value);
        value = configurationFacade.getActiveValueAt("configurationA", "main//max", middle1);
        Assert.assertEquals((Object)"2000", (Object)value);
        configurationFacade.endRun("configurationA", "config1", "tagA", end1);
        value = configurationFacade.getActiveValueAt("configurationA", "main//info", middle1);
        Assert.assertEquals((Object)"testMain", (Object)value);
        value = configurationFacade.getActiveValueAt("configurationA", "main//max", middle1);
        Assert.assertEquals((Object)"2000", (Object)value);
        long start2 = end1 + 1000L;
        long end2 = start2 + 2000L;
        long middle2 = (start2 + end2) / 2L;
        configurationFacade.registerRun(staticConfigProfile.getSubsystemName(), staticConfigProfile.getName(), staticConfigProfile.getTag(), start2);
        ConfigProfile engineeringProfile = Factories.copyProfile((ConfigProfile)staticConfigProfile, (String)"_engineering(config2)", (boolean)true);
        Assert.assertNotNull((Object)engineeringProfile);
        configurationFacade.registerConfigProfile(engineeringProfile);
        Assert.assertTrue((engineeringProfile.getId() > 0L ? 1 : 0) != 0);
        configurationFacade.registerRun(engineeringProfile.getSubsystemName(), engineeringProfile.getName(), engineeringProfile.getTag(), start2 + 100L);
        configurationFacade.modifyParmDuringEngineering(engineeringProfile, "main//max", middle2 - 100L, "1000");
        configurationFacade.modifyParmDuringEngineering(engineeringProfile, "main//max", middle2 + 100L, "1500");
        Assert.assertEquals((Object)"1000", (Object)configurationFacade.getActiveValueAt("configurationA", "main//max", middle2));
        Assert.assertEquals((Object)"1500", (Object)configurationFacade.getActiveValueAt("configurationA", "main//max", middle2 + 200L));
        ConfigProfile registeredProfileA = Factories.copyProfile((ConfigProfile)engineeringProfile, (String)"configNew", (boolean)false);
        Assert.assertFalse((String)"New profile should NOT be in engineering mode", (boolean)registeredProfileA.isDirty());
        configurationFacade.registerConfigProfile(registeredProfileA);
        Assert.assertTrue((String)"id of profile should be positive", (registeredProfileA.getId() > 0L ? 1 : 0) != 0);
        configurationFacade.registerRun(registeredProfileA.getSubsystemName(), registeredProfileA.getName(), registeredProfileA.getTag(), end2);
        ConfigProfile cp = configurationFacade.getConfigRunningAt("configurationA", end2 + 200L);
        Assert.assertEquals((String)"registered profile should be running.", (Object)registeredProfileA.getName(), (Object)cp.getName());
        List res = configurationFacade.simpleHQLRequest("from GhostSubsystemDescription");
        System.out.println("GHOST= " + res);
        res = configurationFacade.simpleHQLRequest(" SELECT P FROM GhostSubsystemDescription G left join G.paramDescriptions as P WHERE G.id=1 AND P.simpleName='son//max'");
        Assert.assertEquals((String)"Description value : ", (Object)"1000", (Object)((ParameterDescription)res.get(0)).getParameterBase().getDefaultValue());
        NodeModularSubsystem rawSub = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"configurationA");
        rawSub.start();
        rawSub.switchToEngineeringMode();
        Assert.assertNotNull((Object)rawSub);
        rawSub.shutdown();
    }
}

