/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.util.HashMap;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.framework.BulkSettingException;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.node_building.ModuleWithMapParms;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class Configuration2parmsBTest
extends CcsTestCaseTemplate {
    private static NodeModularSubsystem s = null;
    private static ModuleWithMapParms mainModule = null;
    private static ModuleWithMapParms mapChild = null;

    @Before
    public void initAgents() throws Exception {
        s = (NodeModularSubsystem)BootUtils.getSubsystemFromFile((String)"mapParmsA");
        mainModule = (ModuleWithMapParms)((Object)s.getLookup().getComponentByName("main"));
        mapChild = (ModuleWithMapParms)((Object)s.getLookup().getComponentByName("mapChild"));
        s.start();
        Thread.sleep(1000L);
    }

    @After
    public void shutdownAgents() throws Exception {
        try {
            s.shutdown();
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown at shutdown : " + ex), (boolean)false);
        }
    }

    @Test
    public void testMapConfiguration() throws Exception {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("min", 20);
        map.put("max", 97);
        mainModule.change("minMax", map);
        Assert.assertEquals((String)"Main min value : ", (long)20L, (long)mainModule.getMin());
        Assert.assertEquals((String)"Main max value : ", (long)97L, (long)mainModule.getMax());
    }

    @Test
    public void testMapPredicateConfiguration() throws Exception {
        HashMap<String, Integer> smallMap = new HashMap<String, Integer>();
        smallMap.put("min", 12);
        smallMap.put("max", 42);
        mapChild.change("minMax", smallMap);
        System.out.println(" state of MapChild " + (Object)((Object)mapChild));
        Assert.assertEquals((String)"mapChild min value : ", (long)12L, (long)mapChild.getMin());
        Assert.assertEquals((String)"mapChild max value : ", (long)42L, (long)mapChild.getMax());
        HashMap<String, Integer> failMap = new HashMap<String, Integer>();
        failMap.put("min", 9);
        failMap.put("max", 200);
        try {
            mapChild.change("minMax", failMap);
            Assert.fail((String)"InvocationTargetException expected");
        }
        catch (BulkSettingException bulkSettingException) {
            // empty catch block
        }
        mapChild.change("minMax", "[min:13,max:41]");
        Assert.assertEquals((String)"mapChild min value : ", (long)13L, (long)mapChild.getMin());
        Assert.assertEquals((String)"mapChild max value : ", (long)41L, (long)mapChild.getMax());
    }
}

