package org.lsst.ccs.startup.remote;

import org.lsst.ccs.config.NamesAndTag;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.remote.scripts.ConfigurationBusClient;
import org.lsst.ccs.config.remote.scripts.RegisterConfigurationFromFile;
import org.lsst.ccs.startup.remote.RegisterDescriptionFromFile;

import java.io.InputStream;
import java.util.Properties;
import org.lsst.ccs.config.remote.DescriptionResult;
import org.lsst.ccs.config.remote.ProfileResult;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.utilities.jars.CommonResources;

/**
 * test utility to register configuration to a Configuration server on the buses.
 * This utility uses only data in files.
 * <BR/>
 * There are different cases:
 * <UL>
 * <LI/> registering a description ("descr:")
 * <LI/> registering a description and a configuration ("descr+conf:")
 * <LI/> looking for a description and registering a configuration ("conf:")
 * </UL>
 *
 * @author bamade
 */
// Date: 20/09/12

public class FireConfigRegistration {
   public static void main(String[] args) throws Exception {
        ConfigurationBusClient busClient = new ConfigurationBusClient();
        if (args.length == 0) {
            usage();
            return;
        }
        String todo = args[0];
        if ("descr:".equals(todo)) {
            registerPureDescription(args);

        } else if ("descr+conf:".equals(todo)) {
            registerDescAndConf(args);

        } else if ("conf:".equals(todo)) {
            registerConfiguration(args);
        } else {
            usage();
        }

    }

    public static void registerPureDescription(String[] args) throws Exception {
        String fileName = args[1];
        //verify if this is a "pure description" (by checking the name)
        NamesAndTag namesAndTag = ConfigUtils.namesFromPath(fileName); //split name
        String subsystemName = namesAndTag.getSubsystemName();
        String configName = namesAndTag.getConfigName();
        String tag = namesAndTag.getTag();
        if (!("".equals(configName) && "".equals(tag))) {
            throw new IllegalArgumentException(fileName + " does not represent a core description");
        }
        ////////
        ConfigurationBusClient busClient = new ConfigurationBusClient();
        try {
            RegisterDescriptionFromFile descriptionRegister = new RegisterDescriptionFromFile(busClient);
            DescriptionResult descriptionResult = descriptionRegister.register(fileName);
            SubsystemDescription subsystemDescription = descriptionResult.getResult();
            System.out.println(subsystemDescription);
        } finally {
            busClient.close();
        }
    }

    public static void registerDescAndConf(String[] args) throws Exception {
        String fileName = args[1];
        String categoryName = args[2];
        String configName = args[3] ;
        ConfigurationBusClient client = new ConfigurationBusClient();
        try {
            RegisterDescriptionFromFile descriptionRegister = new RegisterDescriptionFromFile(client);
            RegisterConfigurationFromFile configRegister = new RegisterConfigurationFromFile(client);
            DescriptionResult descriptionResult = descriptionRegister.register(fileName);
            SubsystemDescription subsystemDescription = descriptionResult.getResult();
            //System.out.println(subsystemDescription);
            ProfileResult profileResult = configRegister.register(subsystemDescription,categoryName, configName, "", 10);
            System.out.println(profileResult.getResult());
        } finally {
            client.close();
        }

    }

    public static void registerConfiguration(String[] args)throws Exception{
        String realSubsystemName = args[1];
        String propsFileName = args[2] ;
        ConfigurationBusClient client = new ConfigurationBusClient();
        try {
            NamesAndTag namesAndTag = ConfigUtils.namesFromPath(propsFileName) ;
            String subsystemName = namesAndTag.getSubsystemName() ;
            if(! subsystemName.equals(realSubsystemName)) {
                throw new IllegalArgumentException( subsystemName + "not coherent with " +
                        realSubsystemName  ) ;
            }
            String configName = namesAndTag.getConfigName() ;
            String tag = namesAndTag.getTag() ;
            InputStream is = CommonResources.getInput(FireConfigRegistration.class, propsFileName) ;
            // populates a Properties
            Properties properties = new Properties() ;
            properties.load(is);
            Object res = client.invoke("registerConfiguration", subsystemName, configName, tag, "", 10, properties) ;
            System.out.println(res);

        } finally {
            client.close();
        }

    }

    public static void usage() {
        System.err.println("usage :\n"
                + "\tdescr: pureDescriptionFileName\n"
                + "\tdescr+conf: pureDescriptionFileName confFileName\n"
                + "\tconf: descriptionName confFileName\n"
                + "\tmach:  descriptionName configName tagName");
    }
}
