package org.lsst.ccs.startup;

import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.PackCst;
import org.lsst.ccs.utilities.jars.CommonResources;

import java.io.IOException;
import java.io.InputStream;

/**
 * Boots a subsystem from a local resource.
 * <BR/>
 *
 * @author bamade
 */
// Date: 05/06/12

public class SubsystemBootFromStream {
    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            usage();
            return;
        }
        String pathName = args[1];
        String subsystemAlias = args[0];
        if (pathName.endsWith(".xml")) {
            throw new IllegalArgumentException("Spring no longer supported") ;
            //ModularSubsystem.main(args);
        } else {
            /*
             * if there is a third argument it is the configuration file
             * in that case the first argument is only a raw subsystem description without configuration or tag name
            * */
            String propertiesFileName = null;
            if (args.length > 2) {
                propertiesFileName = args[2];
            }

            //boot susbystem
            Subsystem subsystem = BootUtils.getSubsystemFromFile(pathName, propertiesFileName, subsystemAlias) ;
            subsystem.start();
            //subsystem.stayAlive();

        }
    }

    static InputStream getInput(String pathName) throws IOException {
        return CommonResources.getInput(SubsystemBootFromStream.class, pathName);
    }

    static void usage() {
        System.err.println("usage: java org.lsst.ccs.startup.SubsystemBootfromStream pathName [optionalConfigPropertiesFile]\n"
                + " where filename is  xx.ser or xx.groovy or xx.groo\n"
                + " pathName could be file (with '/' file separator) or resource path");

    }
}
