/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.util.Collections;
import java.util.List;
import org.lsst.ccs.HardwareException;
import org.lsst.ccs.bus.messages.StatusHeartBeat;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.CommandSet;
import org.lsst.ccs.command.CommandSetBuilder;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationEnvironment;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.description.ComponentLookupService;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.HardwareController;
import org.lsst.ccs.framework.Signal;
import org.lsst.ccs.framework.SignalHandler;
import org.lsst.ccs.framework.SignalLevel;
import org.lsst.ccs.framework.TreeWalkerDiag;
import org.lsst.ccs.utilities.structs.ViewValue;

public class NodeModularSubsystem
extends ConfigurableSubsystem {
    private final ComponentLookupService lookup;

    NodeModularSubsystem(String subsystemName, ConfigurationProxy configurationProxy, EffectiveNode effectiveNode, ConfigurationState initialState) throws Exception {
        super(subsystemName, configurationProxy, initialState);
        this.lookup = new ComponentLookupService(effectiveNode);
        this.lookup.proceduralNodeWalk(null, null, node -> {
            String key = node.getKey();
            Object value = node.getRealValue();
            if (value instanceof Configurable) {
                Configurable configurable = (Configurable)value;
                configurable.setEnvironment((Configurable.Environment)new ConfigurationEnvironment(key, configurable, this.getConfigurationProxy(), this.lookup, (ConfigurableSubsystem)this));
            }
        });
        this.doInitComponents();
    }

    protected void updateHeartBeat(StatusHeartBeat s) {
    }

    public ComponentLookupService getLookup() {
        return this.lookup;
    }

    @Deprecated
    public List<ViewValue> getPreOrderComponentList() {
        return Collections.EMPTY_LIST;
    }

    private void doInitComponents() {
        this.lookup.proceduralWalk(null, Configurable.class, Configurable::init, null);
        this.lookup.proceduralNodeWalk(null, node -> {
            CommandSet commandSet = new CommandSetBuilder().buildCommandSet(node.getRealValue());
            String fullPath = this.lookup.getFullPathFor(node.getKey());
            this.addCommandSet(fullPath, commandSet);
        }, null);
    }

    public void doStart() {
        super.doStart();
        this.lookup.proceduralWalk(null, Configurable.class, Configurable::start, null);
    }

    public void postStart() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.proceduralWalk(null, Configurable.class, c -> {
            try {
                c.postStart();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(c.toString() + " at postStart", (Throwable)e, exc[0]);
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void doShutdown() {
        log.fine((Object)("Subsystem " + this.getName() + " shutdown starting"));
        this.lookup.proceduralWalk(null, Configurable.class, Configurable::shutdownNow, null);
    }

    protected Configurable getCommandDestination(String commandDestination) {
        Configurable configurable = null;
        String configurableName = "main";
        if (commandDestination.contains("/")) {
            configurableName = commandDestination.substring(commandDestination.indexOf("/") + 1);
        }
        if ((configurable = (Configurable)this.lookup.getComponentByName(configurableName)) == null) {
            throw new IllegalArgumentException(" no such configurable " + configurableName + " for command destination");
        }
        return configurable;
    }

    @Command(description="halt", type=Command.CommandType.SIGNAL)
    public void abort() {
        super.abort();
        this.sendSignal(new Signal(SignalLevel.HALT));
    }

    @Command(description="halt with expected max delay", type=Command.CommandType.SIGNAL)
    public void abort(long expectedMaxDelay) {
        super.abort();
        this.sendSignal(new Signal(SignalLevel.HALT, expectedMaxDelay));
    }

    @Command(description="stops with expected max delay", type=Command.CommandType.ACTION)
    public void stop(long expectedMaxDelay) throws HardwareException {
        super.stop(expectedMaxDelay);
        this.sendSignal(new Signal(SignalLevel.STOP, expectedMaxDelay));
    }

    @Command(description="stops hardware", type=Command.CommandType.ACTION)
    public void stop() throws HardwareException {
        this.stop(Long.MAX_VALUE);
    }

    private void sendSignal(Signal signal) {
        this.lookup.treeWalk(null, SignalHandler.class, sh -> sh.signal(signal), null);
    }

    @Command(description="waits until all the hardware devices are actually stopped", type=Command.CommandType.ACTION)
    public void stopAndWait(long expectedMaxDelay) throws HardwareException, InterruptedException {
        this.stop(expectedMaxDelay);
        int step = 10;
        long fracDelay = expectedMaxDelay / (long)step;
        HardwareException lastExc = null;
        for (int i = 0; i < step; ++i) {
            try {
                Thread.sleep(fracDelay);
                this.checkAllHardwareStopped();
                return;
            }
            catch (HardwareException e) {
                lastExc = e;
                continue;
            }
        }
        throw lastExc;
    }

    public void checkHardware() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.treeWalk(null, HardwareController.class, hc -> {
            try {
                return hc.checkHardware();
            }
            catch (HardwareException e) {
                exc[0] = new HardwareException(hc.toString() + "not started ", (Throwable)e, exc[0]);
                if (e.isFatal()) {
                    return TreeWalkerDiag.STOP;
                }
                return TreeWalkerDiag.GO;
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStarted() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.proceduralWalk(null, Configurable.class, configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStarted();
                }
                catch (HardwareException e) {
                    exc[0] = new HardwareException(configurable.toString() + "not started ", (Throwable)e, exc[0]);
                }
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }

    public void checkAllHardwareStopped() throws HardwareException {
        HardwareException[] exc = new HardwareException[]{null};
        this.lookup.proceduralWalk(null, Configurable.class, configurable -> {
            if (configurable instanceof HardwareController) {
                try {
                    ((HardwareController)configurable).checkStopped();
                }
                catch (HardwareException e) {
                    exc[0] = new HardwareException(configurable.toString() + "not started ", (Throwable)e, exc[0]);
                }
            }
        }, null);
        if (exc[0] != null) {
            throw exc[0];
        }
    }
}

