/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.startup;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.lsst.ccs.CCSCst;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.AParameterDescription;
import org.lsst.ccs.config.ConfigProfile;
import org.lsst.ccs.config.ConfigurableSubsystem;
import org.lsst.ccs.config.ConfigurationProxy;
import org.lsst.ccs.config.DataFlavour;
import org.lsst.ccs.config.Factories;
import org.lsst.ccs.config.LocalConfigurationProxy;
import org.lsst.ccs.config.ParameterBase;
import org.lsst.ccs.config.ParameterConfiguration;
import org.lsst.ccs.config.ParameterDescription;
import org.lsst.ccs.config.ParameterPath;
import org.lsst.ccs.config.SubsystemDescription;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.description.ComponentNodeBuilder;
import org.lsst.ccs.description.DescriptiveNode;
import org.lsst.ccs.description.EffectiveNode;
import org.lsst.ccs.startup.NodeModularSubsystem;
import org.lsst.gruth.jutils.Constraints;
import org.lsst.gruth.jutils.HollowParm;
import org.lsst.gruth.jutils.NamedRefParm;
import org.lsst.gruth.nodes.ComponentFactory;

public class BootUtils {
    public static SubsystemDescription buildSubsystemDescription(String subsystemName, String tagName, DescriptiveNode descriptiveNode, DataFlavour dataFlavour) {
        SubsystemDescription res = Factories.createRawSubsystemDescription((String)subsystemName, (String)tagName, (Serializable)descriptiveNode, (DataFlavour)dataFlavour);
        ArrayList<ParameterDescription> list = new ArrayList<ParameterDescription>();
        BootUtils.populateParameterDescriptionsFromTop(list, descriptiveNode);
        res.addParameterDescriptions(list);
        return res;
    }

    private static void populateParameterDescriptionsFromTop(Collection<ParameterDescription> list, DescriptiveNode topNode) {
        list.addAll(BootUtils.parameterDescriptionsFromNode(topNode));
        ArrayList children = topNode.getChildren();
        for (DescriptiveNode childNode : children) {
            BootUtils.populateParameterDescriptionsFromTop(list, childNode);
        }
    }

    private static Collection<ParameterDescription> parameterDescriptionsFromNode(DescriptiveNode node) {
        ArrayList<ParameterDescription> res = new ArrayList<ParameterDescription>();
        Map attributes = node.getAttributes();
        String nodeKey = node.getKey();
        if (attributes != null) {
            Set keyVals = attributes.entrySet();
            for (Map.Entry entry : keyVals) {
                HollowParm hollow;
                Object val = entry.getValue();
                String parmName = (String)entry.getKey();
                if ("name".equalsIgnoreCase(parmName) || val instanceof NamedRefParm || !(val instanceof HollowParm) || (hollow = (HollowParm)val).isReadOnly()) continue;
                String typeName = hollow.getValueClass().getName();
                ParameterBase base = new ParameterBase(nodeKey, "", parmName, typeName, hollow.toString());
                String description = "";
                String simpleName = "";
                String constraints = "";
                String category = "";
                boolean notModifiableAtRuntime = false;
                int level = 0;
                Properties props = hollow.getProperties();
                if (props != null) {
                    String isStatic;
                    description = props.getProperty("description", "");
                    simpleName = props.getProperty("simpleName", "");
                    constraints = props.getProperty("constraints", "");
                    Constraints.check((String)typeName, (String)base.getDefaultValue(), (String)constraints);
                    category = props.getProperty("category", "");
                    String request = props.getProperty("level");
                    if (request != null) {
                        level = Integer.parseInt(request);
                    }
                    if ((isStatic = props.getProperty("static")) != null) {
                        notModifiableAtRuntime = Boolean.valueOf(isStatic);
                    }
                }
                AParameterDescription parmDescription = new AParameterDescription(base, description, simpleName, constraints, category, level);
                parmDescription.setNotModifiableAtRuntime(notModifiableAtRuntime);
                res.add((ParameterDescription)parmDescription);
            }
        }
        return res;
    }

    static EffectiveNode buildEffectiveNode(DescriptiveNode descriptionNode) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        ComponentFactory fact = new ComponentFactory(descriptionNode);
        EffectiveNode top = fact.build();
        return top;
    }

    public static Subsystem getSubsystemFromFile(String descriptionName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, null);
    }

    public static Subsystem getSubsystemFromFile(String descriptionName, String configName) throws Exception {
        return BootUtils.getSubsystemFromFile(descriptionName, configName, null);
    }

    public static Subsystem getSubsystemFromFile(String pathName, String propertiesFileName, String subsystemAlias) throws Exception {
        return new LocalBootObject(pathName, propertiesFileName, subsystemAlias).getSubsystem();
    }

    public static void saveInCache(DescriptiveNode node, String subsystemName, String configName, String tag) {
    }

    public static DescriptiveNode getLatestInCache() {
        return null;
    }

    public static void bootFromCache() {
        throw new UnsupportedOperationException("bootFromCache");
    }

    public static DescriptiveNode modifyDescriptiveNode(DescriptiveNode node, Set<? extends ParameterConfiguration> parmConfigs) {
        DescriptiveNode res = node.clone();
        for (ParameterConfiguration parameterConfiguration : parmConfigs) {
            ParameterPath path = parameterConfiguration.getPath();
            String componentName = path.getComponentName();
            String codeName = path.getCodeName();
            if (codeName != null && !"".equals(codeName)) {
                throw new UnsupportedOperationException(" no change on methods yet --> " + codeName);
            }
            String parameterName = path.getParameterName();
            DescriptiveNode goalComponent = (DescriptiveNode)res.getNodeByName(componentName);
            if (goalComponent == null) {
                throw new IllegalArgumentException("no component for name :" + componentName);
            }
            Map mapAttributes = goalComponent.getAttributes();
            if (mapAttributes == null) {
                throw new IllegalArgumentException("incompatible attribute list for component//parameter " + path);
            }
            Object rawParm = mapAttributes.get(parameterName);
            if (rawParm instanceof HollowParm) {
                HollowParm hollow = (HollowParm)rawParm;
                hollow.modifyChecked((Object)parameterConfiguration.getConfiguredValue());
                continue;
            }
            throw new IllegalArgumentException("parameter not modifiable" + rawParm);
        }
        return res;
    }

    public static void checkStaticCompatibleConfiguration(ConfigProfile profile) throws Exception {
        DescriptiveNode node = (DescriptiveNode)profile.getSubsystemDescription().getDescriptionData();
        Set parmConfigs = profile.getModifiedParameters();
        DescriptiveNode modifiedDescriptiveNode = BootUtils.modifyDescriptiveNode(node, parmConfigs);
        BootUtils.buildEffectiveNode(modifiedDescriptiveNode);
    }

    public static class LocalBootObject {
        DescriptiveNode descriptiveNode;
        DescriptiveNode modifiedDescriptiveNode;
        EffectiveNode effectiveNode;
        ConfigurableSubsystem subsystem;
        private final String subsystemName;
        private final String[] taggedCategories;
        private String tagName;

        public LocalBootObject(String pathName) throws Exception {
            this(pathName, "");
        }

        public LocalBootObject(String fullDescription, String config) throws Exception {
            this(fullDescription, config, null);
        }

        public LocalBootObject(String fullDescription, String config, String subsystemAlias) throws Exception {
            if (config == null) {
                config = "";
            }
            if (config.contains("/")) {
                throw new IllegalArgumentException("configuration files must be located at the root of a resource directory");
            }
            if (config.contains(".")) {
                throw new IllegalArgumentException("configuration input must be the name of the configuration only");
            }
            this.descriptiveNode = ComponentNodeBuilder.buildDescriptiveNode((String)fullDescription);
            this.subsystemName = subsystemAlias == null ? this.descriptiveNode.getSubsystemName() : subsystemAlias;
            this.taggedCategories = config.split(",");
            this.tagName = fullDescription;
            if (fullDescription.contains(":")) {
                this.tagName = fullDescription.substring(fullDescription.indexOf(58) + 1);
            }
            CCSCst.LOG_TODO.fine((Object)"TODO: Configuration proxy should also be able to interact with remote database (switch between local and remote?)");
            SubsystemDescription subsystemDescription = BootUtils.buildSubsystemDescription(this.subsystemName, this.tagName, this.descriptiveNode, DataFlavour.PURE_OBJECT_TREE);
            LocalConfigurationProxy proxy = new LocalConfigurationProxy(subsystemDescription);
            Map.Entry stateAndParmConfigs = proxy.getInitialParameterConfigurations(ConfigUtils.parseConfigurationStringWithDefaults((Set)subsystemDescription.getCategorySet(), (String[])this.taggedCategories));
            this.modifiedDescriptiveNode = BootUtils.modifyDescriptiveNode(this.descriptiveNode, (Set)stateAndParmConfigs.getValue());
            this.effectiveNode = BootUtils.buildEffectiveNode(this.modifiedDescriptiveNode);
            this.subsystem = new NodeModularSubsystem(this.subsystemName, (ConfigurationProxy)proxy, this.effectiveNode, (ConfigurationState)stateAndParmConfigs.getKey());
        }

        public DescriptiveNode getDescriptiveNode() {
            return this.descriptiveNode;
        }

        public DescriptiveNode getModifiedDescriptiveNode() {
            return this.modifiedDescriptiveNode;
        }

        public Subsystem getSubsystem() {
            return this.subsystem;
        }

        public String getSubsystemName() {
            return this.subsystemName;
        }

        public String getTagName() {
            return this.tagName;
        }

        public Object getRunningObject(String key) {
            return this.effectiveNode.getIndirect((Object)key);
        }
    }
}

