package org.lsst.ccs.node_building
import org.lsst.ccs.startup.CCSBuilder

import static org.lsst.gruth.jutils.MapArgs.*

CCSBuilder builder = ["simpleParmsA"]

builder.
    "main" (ModuleWithSimpleParms, argMap(a("name", "main"),
            aString("aString", "Hello"),
            anInt("anInt",100, [constraints: 0..200]),
            aBool("aBool", true, [static:true]),
            aDbl("aDouble",33.33))) {
        // simpleParms as String
        "stringValues" (ModuleWithSimpleParms, argMap(a("name", "StringValues"),
                aString("aString", "Hello"),
                anInt("anInt","100", [constraints: 0..200]),
                aBool("aBool", "true", [static:true]),
                aDbl("aDouble","33.33")))
        //Litterals
        "litterals" (ModuleWithSimpleParms, argList( "litterals",
                "Hello",
                100,
                true,
                33.33))
        // part litterals
        "partLitterals" (ModuleWithSimpleParms, argMap( "partLitterals",
                "Hello",
                anInt("anInt",100, [constraints: 0..200]),
                aBool("aBool", true, [static:true]),
                33.33))
        // uses ConstructorProperties
        "ctorProps" (ModuleWithSimpleParms, argMap(a("name", "ctorProps"),
                aBool("aBool", true, [static:true]),
                anInt("anInt",100, [constraints: 0..200]),
                aDbl("aDouble",33.33)))
        // uses named parameters from java 8
        "namedParms" (ModuleWithSimpleParms, argMap(a("name", "ctorProps"),
                aBool("aBool", true, [static:true]),
                anInt("anInt",100, [constraints: 0..200]),
                aDbl("aDouble",33.33),
                aString("aString", "hello") ))

        ///////////////////////////////////////////////////////////////
        // CONFIGURABLE THAT ARE NOT MODULES
        ///////////////////////////////////////////////////////////////

        "cfTop" (ConfigurableWithSimpleParms, argMap(
                aString("aString", "Hello"),
                anInt("anInt",100, [constraints: 0..200]),
                aBool("aBool", true, [static:true]),
                aDbl("aDouble",33.33))) {
            // simpleParms as String
            "cfStringValues"(ConfigurableWithSimpleParms, argMap(
                    aString("aString", "Hello"),
                    anInt("anInt", "100", [constraints: 0..200]),
                    aBool("aBool", "true", [static: true]),
                    aDbl("aDouble", "33.33")))
            //Litterals
            "cfLitterals"(ConfigurableWithSimpleParms, argList(
                    "Hello",
                    100,
                    true,
                    33.33))
            // part litterals
            "cfPartLitterals"(ConfigurableWithSimpleParms, argMap(
                    "Hello",
                    anInt("anInt", 100, [constraints: 0..200]),
                    aBool("aBool", true, [static: true]),
                    33.33))
            // uses ConstructorProperties
            "cfCtorProps"(ConfigurableWithSimpleParms, argMap(
                    aBool("aBool", true, [static: true]),
                    anInt("anInt", 100, [constraints: 0..200]),
                    aDbl("aDouble", 33.33)))
        }
        "cfTop2" (ConfigurableWithSimpleParms, argMap(
                aString("aString", "Hello"),
                anInt("anInt",100, [constraints: 0..200]),
                aBool("aBool", true, [static:true]),
                aDbl("aDouble",33.33)))
    }