package org.lsst.ccs.config

import org.lsst.ccs.startup.CCSBuilder

import static org.lsst.gruth.jutils.MapArgs.*

CCSBuilder builder = ["configured"]


builder.
        "main" (ConfigureMe ,
    argMap (aString('otherKey', 'parent', [static: true]),
        aString('info', 'testMain', [static: true]),
        anInt('min', 256, [constraints: 0..2048]),
        anInt('max', 500, [constraints: 0..2048]),
        aDbl('value', 3.14D)
    ) ) {
    /**/
            "son" (ConfigureMe,
        argMap(aString('otherKey', 'child', [static: true]),
            aString('info', 'testChild'),
            anInt('min', 0, [constraints: 0..2048]),
            anInt('max', 1000, [constraints: 0..2048]),
            aDbl('value', 3.14D, [constraints: 0..2048])

        ))

            "predicateSon" (ConfigureMe,
        argMap(aString('otherKey', 'child', [static: true]),
            aString('info', 'testChild'),
            anInt('min', 0, [constraints: 0..2048]),
            anInt('max', 1000, [constraints: 0..2048]),
            aDbl('value', 3.14D, [constraints: predicate ('x', 'x>2')])

        ))
            "withBulkSetting"(BulkChangeConfigurable,
        argMap(aString('otherKey', 'child', [static: true]),
            aString('info', 'testChild'),
            anInt('min', 0, [constraints: 0..2048]),
            anInt('max', 1000, [constraints: 0..2048]),
            aDbl('value', 3.14D, [constraints: predicate ('x', 'x>2')]),
            aBool('failing', false))
        )
    
           "withFailingBulkSetting"(BulkChangeConfigurable,
        argMap(aString('otherKey', 'child', [static: true]),
            aString('info', 'testChild'),
            anInt('min', 0, [constraints: 0..2048]),
            anInt('max', 1000, [constraints: 0..2048]),
            aDbl('value', 3.14D, [constraints: predicate ('x', 'x>2')]),
            aBool('failing', true))
        )

}