/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.node_building;

import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.config.InMemoryWriterProvider;
import org.lsst.ccs.config.utilities.ConfigUtils;
import org.lsst.ccs.framework.Configurable;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.messaging.CcsTestCaseTemplate;
import org.lsst.ccs.node_building.ModuleWithMapParms;
import org.lsst.ccs.node_building.ModuleWithStructParms;
import org.lsst.ccs.node_building.ModuleWithVarargsParms;
import org.lsst.ccs.startup.BootUtils;
import org.lsst.ccs.startup.NodeModularSubsystem;

public class NodeBuildingTest
extends CcsTestCaseTemplate {
    private static final String simpleParmsAPath = "simpleParmsA";
    private static final String mapParmsAPath = "mapParmsA";
    private static final String varargsParmsAPath = "varargsParmsA";
    private static final String mapParmsAOKProps = "ok";
    private static final String mapParmsAFailProps = "fail";

    @Before
    public void initTest() {
        InMemoryWriterProvider.newInstance();
    }

    @Test
    public void testSimpleParmsDirectBuild() throws Exception {
        BootUtils.LocalBootObject bootObj = new BootUtils.LocalBootObject(simpleParmsAPath);
        Module mainModule = (Module)bootObj.getRunningObject("main");
        LinkedHashMap modules = mainModule.getChildren(Module.class);
        for (Map.Entry entry : modules.entrySet()) {
            Module m = (Module)entry.getValue();
            Assert.assertEquals((String)("main module and " + m + " child should be equal"), (Object)mainModule, (Object)m);
        }
        Configurable topConfigurable = (Configurable)bootObj.getRunningObject("cfTop");
        LinkedHashMap configurables = topConfigurable.getChildren(Configurable.class);
        for (Map.Entry entry : configurables.entrySet()) {
            Configurable c = (Configurable)entry.getValue();
            Assert.assertEquals((String)("top configurable and " + c + " child should be equal"), (Object)topConfigurable, (Object)c);
        }
    }

    @Test
    public void testMapParmsDirectBuild() {
        BootUtils.LocalBootObject bootObj = null;
        try {
            bootObj = new BootUtils.LocalBootObject(mapParmsAPath);
            ModuleWithMapParms mainModule = (ModuleWithMapParms)((Object)bootObj.getRunningObject("main"));
            ModuleWithStructParms structModule = (ModuleWithStructParms)((Object)bootObj.getRunningObject("structChild"));
            Assert.assertNotEquals((String)("min should be set " + mainModule.min), (long)0L, (long)mainModule.min);
            Assert.assertNotEquals((String)("max should be set " + mainModule.max), (long)0L, (long)mainModule.max);
            Assert.assertNotEquals((String)("min should be set " + structModule.min), (long)0L, (long)structModule.min);
            Assert.assertNotEquals((String)("max should be set " + structModule.max), (long)0L, (long)structModule.max);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)false);
        }
    }

    @Test
    public void testMapParmsPropsOKDirect() throws Exception {
        PrintWriter printWriter = InMemoryWriterProvider.getInstance().getPrintWriter(ConfigUtils.baseNameFromNames((String)mapParmsAOKProps, (String)mapParmsAPath, (String)""));
        printWriter.println("main//minMax=[min:11,max:99]");
        printWriter.println("mapChild//minMax=[min:11,max:99]");
        printWriter.println("structChild//minMax=[11,99]");
        printWriter.println("structChild2//minMax=[11,99]");
        printWriter.flush();
        printWriter.close();
        BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)mapParmsAOKProps);
    }

    @Test
    public void testMapParmsPropsFailDirect() throws Exception {
        PrintWriter printWriter = InMemoryWriterProvider.getInstance().getPrintWriter(ConfigUtils.baseNameFromNames((String)mapParmsAFailProps, (String)mapParmsAPath, (String)""));
        printWriter.println("main//minMax=[min:0,max:99]");
        printWriter.println("mapChild//minMax=[min:0,max:99]");
        printWriter.println("structChild//minMax=[0,99]");
        printWriter.println("structChild2//minMax=[0,99]");
        printWriter.flush();
        printWriter.close();
        try {
            BootUtils.getSubsystemFromFile((String)mapParmsAPath, (String)mapParmsAFailProps);
            Assert.fail((String)"configuration loading should fail");
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)(ex instanceof IllegalArgumentException));
        }
    }

    @Test
    public void testvarargsParmsADirectBuild() {
        Subsystem s = null;
        try {
            s = BootUtils.getSubsystemFromFile((String)varargsParmsAPath);
        }
        catch (Exception ex) {
            Assert.assertTrue((String)("Exception thrown : " + ex), (boolean)false);
            return;
        }
        ModuleWithVarargsParms m1 = (ModuleWithVarargsParms)((Object)((NodeModularSubsystem)s).getLookup().getComponentByName("varargs1"));
        ModuleWithVarargsParms m2 = (ModuleWithVarargsParms)((Object)((NodeModularSubsystem)s).getLookup().getComponentByName("varargs2"));
        Assert.assertEquals((String)"varargs1 length : ", (long)2L, (long)m1.getParmsSize());
        Assert.assertEquals((String)"varargs2 length : ", (long)3L, (long)m2.getIntParmsSize());
    }
}

